#ifndef UART_H
#define UART_H

#define MAXUARTBUF 125

#define UART1_BREAK_CHAR        0x0D    //(CR)

#define UART1_RECV_BUFFER
//#define UART1_RECV_XBEE

typedef struct __UART_DATA {
    unsigned char buffer_in[MAXUARTBUF];
    unsigned char buffer_in_read_ind;
    unsigned char buffer_in_write_ind;
    unsigned char buffer_in_len;
    unsigned char buffer_in_len_tmp;

    unsigned char buffer_out[MAXUARTBUF];
    unsigned char buffer_out_ind;
    unsigned char buffer_out_len;
} UART_DATA;

void UART1_Init(void);
void UART1_Recv_Interrupt_Handler(void);
void UART1_Send_Interrupt_Handler(void);
void UART1_WriteS(const rom char *fmt, ...);
void UART1_WriteF(float f, unsigned char m);
void UART1_WriteB(const char *msg, unsigned char length);
void UART1_WriteC(const unsigned char c);
unsigned char UART1_Buffer_Len(void);
unsigned char UART1_Read_Buffer(unsigned char *buffer);
#endif
