#ifndef TEMP_BMP085_H
#define	TEMP_BMP085_H

#define BMP085_I2CADDR 0x77

#define BMP085_ULTRALOWPOWER    0
#define BMP085_STANDARD         1
#define BMP085_HIGHRES          2
#define BMP085_ULTRAHIGHRES     3
#define BMP085_CAL_AC1           0xAA  // R   Calibration data (16 bits)
#define BMP085_CAL_AC2           0xAC  // R   Calibration data (16 bits)
#define BMP085_CAL_AC3           0xAE  // R   Calibration data (16 bits)
#define BMP085_CAL_AC4           0xB0  // R   Calibration data (16 bits)
#define BMP085_CAL_AC5           0xB2  // R   Calibration data (16 bits)
#define BMP085_CAL_AC6           0xB4  // R   Calibration data (16 bits)
#define BMP085_CAL_B1            0xB6  // R   Calibration data (16 bits)
#define BMP085_CAL_B2            0xB8  // R   Calibration data (16 bits)
#define BMP085_CAL_MB            0xBA  // R   Calibration data (16 bits)
#define BMP085_CAL_MC            0xBC  // R   Calibration data (16 bits)
#define BMP085_CAL_MD            0xBE  // R   Calibration data (16 bits)

#define BMP085_CONTROL           0xF4
#define BMP085_TEMPDATA          0xF6
#define BMP085_PRESSUREDATA      0xF6
#define BMP085_READTEMPCMD       0x2E
#define BMP085_READPRESSURECMD   0x34

typedef struct __BMP085_DATA {
    int ac1, ac2, ac3, b1, b2, mb, mc, md;
    unsigned int ac4, ac5, ac6;
    unsigned char oversampling;
} BMP085_DATA;

void BMP_Init(void);
void BMP_Begin(unsigned char mode);
unsigned int BMP_Read_Raw_Temperature(void);
unsigned long BMP_Read_Raw_Pressure(void);
float BMP_Read_Temperature(void);
long BMP_Read_Pressure(void);
float BMP_Read_Altitude(float seaLevelPressure);

unsigned char BMP_Read8(unsigned char a);
unsigned int BMP_Read16(unsigned char a);
void BMP_Write8(unsigned char a, unsigned char d);

#endif	/* TEMP_BMP085_H */

