#ifndef SPI_H
#define	SPI_H

#include "defines.h"

#define MAXSPIBUF 64

// Option to use interrupt. If interrupt are used, SPI write does not block but
//  there is a longer delay between reading/writing data
//#define SPI2_USE_INTERRUPT

// SPI speed selection
#define SPI2_FOSC_64        0b0010
#define SPI2_FOSC_16        0b0001
#define SPI2_FOSC_8         0b1010
#define SPI2_FOSC_4         0b0000

typedef struct __SPI_DATA {
#ifndef SPI2_WRITE_ONLY
    unsigned char buffer_in[MAXSPIBUF];
    unsigned char buffer_in_read_ind;
    unsigned char buffer_in_write_ind;
    unsigned char buffer_in_len;
#endif

    unsigned char buffer_out[MAXSPIBUF];
    unsigned char buffer_out_ind;
    unsigned char buffer_out_len;
} SPI_DATA;

void SPI2_Init(unsigned char speed);
void SPI2_Write(unsigned char *msg, unsigned int length);
void SPI2_Write_Repeat(unsigned char c, unsigned int length);
#ifndef SPI2_WRITE_ONLY
void SPI2_Recv_Interrupt_Handler(void);
void SPI2_Read(unsigned char length);
unsigned char SPI2_Buffer_Len(void);
unsigned char SPI2_Read_Buffer(unsigned char *buffer);
#endif

#endif	/* SPI_H */

