#include "maindefs.h"
#include "pwm.h"
#include <pwm.h>

void pwm_init() {
    // Configure pins RC5 and RC7 as outputs
    TRISCbits.TRISC0 = 0;
    TRISCbits.TRISC1 = 0;
    LATCbits.LATC0 = 0;
    LATCbits.LATC1 = 0;

    RPOR11 = 14;    // Set RP11 to ECCP1 PWM Output Channel A
    RPOR12 = 15;    // Set RP12 to ECCP1 PWM Output Channel B
}

void pwm_start() {
    OpenEPWM1(0xFF, ECCP_1_SEL_TMR12);  // 38kHz Frequency
    SetDCEPWM1(512);                    // 50% Duty Cycle

    // Wait for completion of a full PWM cycle before enabling output mode
    while(!PIR1bits.TMR2IF);
    SetOutputEPWM1(SINGLE_OUT, PWM_MODE_1);

    // Enable ECCP1 output channels A and B
    PSTR1CONbits.STRA = 1;
    PSTR1CONbits.STRB = 1;
}

void pwm_stop() {
    CloseEPWM1();
}