#ifndef OLED_SSD1306_H
#define	OLED_SSD1306_H

/*=========================================================================
SSD1306 Displays
-----------------------------------------------------------------------
The driver is used in multiple displays (128x64, 128x32, etc.).
Select the appropriate display below to create an appropriately
sized framebuffer, etc.

SSD1306_128_64  128x64 pixel display

SSD1306_128_32  128x32 pixel display

You also need to set the LCDWIDTH and LCDHEIGHT defines to an
appropriate size

-----------------------------------------------------------------------*/
    #define SSD1306_128_64
//    #define SSD1306_128_32
/*=========================================================================*/

#if defined SSD1306_128_64
    #define SSD1306_LCDWIDTH                  128
    #define SSD1306_LCDHEIGHT                 64
#endif
#if defined SSD1306_128_32
    #define SSD1306_LCDWIDTH                  128
    #define SSD1306_LCDHEIGHT                 32
#endif

#define SSD1306_STRING_BUFFER_SIZE          32

#define SSD1306_BLACK 0
#define SSD1306_WHITE 1

#define SSD1306_I2C_ADDRESS   0x3D	// 011110+SA0+RW

#define SSD1306_SETCONTRAST 0x81
#define SSD1306_DISPLAYALLON_RESUME 0xA4
#define SSD1306_DISPLAYALLON 0xA5
#define SSD1306_NORMALDISPLAY 0xA6
#define SSD1306_INVERTDISPLAY 0xA7
#define SSD1306_DISPLAYOFF 0xAE
#define SSD1306_DISPLAYON 0xAF
#define SSD1306_SETDISPLAYOFFSET 0xD3
#define SSD1306_SETCOMPINS 0xDA
#define SSD1306_SETVCOMDETECT 0xDB
#define SSD1306_SETDISPLAYCLOCKDIV 0xD5
#define SSD1306_SETPRECHARGE 0xD9
#define SSD1306_SETMULTIPLEX 0xA8
#define SSD1306_SETLOWCOLUMN 0x00
#define SSD1306_SETHIGHCOLUMN 0x10
#define SSD1306_SETSTARTLINE 0x40
#define SSD1306_MEMORYMODE 0x20
#define SSD1306_COMSCANINC 0xC0
#define SSD1306_COMSCANDEC 0xC8
#define SSD1306_SEGREMAP 0xA0
#define SSD1306_CHARGEPUMP 0x8D
#define SSD1306_EXTERNALVCC 0x1
#define SSD1306_SWITCHCAPVCC 0x2

typedef struct __SSD1306_DATA {
    int WIDTH, HEIGHT; // raw display size
    int _width, _height; // size depending on rotation
    int cursor_x, cursor_y;
    unsigned int textcolor, textbgcolor;
    unsigned char textsize;
    unsigned char rotation;
    unsigned char wrap; // If set, wrap text at right side
} SSD1306_DATA;

// Misc functions
int SSD1306_Abs(int i);
void SSD1306_Swap(int *a, int *b);

// Core functions
void SSD1306_Init(void);
void SSD1306_Begin(unsigned char vcc);
void SSD1306_Command(unsigned char cmd);
void SSD1306_Data(unsigned char data);

void SSD1306_Clear_Display(void);
void SSD1306_Invert_Display(unsigned char);
void SSD1306_Display(void);

// Drawing functions
void SSD1306_Draw_Pixel(int x, int y, unsigned int color);
void SSD1306_Draw_Line(int x0, int y0, int x1, int y1, unsigned int color);
void SSD1306_Draw_Fast_VLine(int x, int y, int h, unsigned int color);
void SSD1306_Draw_Fast_HLine(int x, int y, int w, unsigned int color);
void SSD1306_Draw_Rect(int x, int y, int w, int h, unsigned int color);
void SSD1306_Fill_Rect(int x, int y, int w, int h, unsigned int color);

void SSD1306_Draw_Circle(int x0, int y0, int r, unsigned int color);
void SSD1306_Draw_Circle_Helper(int x0, int y0, int r, unsigned char cornername, unsigned int color);
void SSD1306_Fill_Circle(int x0, int y0, int r, unsigned int color);
void SSD1306_Fill_Circle_Helper(int x0, int y0, int r, unsigned char cornername, int delta, unsigned int color);

void SSD1306_Draw_Triangle(int x0, int y0, int x1, int y1, int x2, int y2, unsigned int color);
void SSD1306_Fill_Triangle(int x0, int y0, int x1, int y1, int x2, int y2, unsigned int color);
void SSD1306_Draw_Round_Rect(int x0, int y0, int w, int h, int radius, unsigned int color);
void SSD1306_Fill_Round_Rect(int x0, int y0, int w, int h, int radius, unsigned int color);

void SSD1306_Draw_Bitmap(int x, int y, const unsigned char *bitmap, int w, int h, unsigned int color);
void SSD1306_Draw_Char(int x, int y, unsigned char c, unsigned int color, unsigned int bg, unsigned char size);

void SSD1306_Write(unsigned char c);
void SSD1306_Write_String(const rom char *fmt, ...);
//void SSD1306_Append_String(const rom char *fmt, ...);

void SSD1306_Set_Cursor(int x, int y);
void SSD1306_Set_Text_Color(unsigned int c);
void SSD1306_Set_Text_Color_BG(unsigned int c, unsigned int bg);
void SSD1306_Set_Text_Size(unsigned char s);
void SSD1306_Set_Text_Wrap(unsigned char w);
void SSD1306_Set_Rotation(unsigned char r);

// Test functions
void SSD1306_Test_DrawChar(void);
void SSD1306_Test_DrawCircle(void);
void SSD1306_Test_DrawRect(void);
void SSD1306_Test_FillRect(void);
void SSD1306_Test_DrawTriangle(void);
void SSD1306_Test_FillTriangle(void);
void SSD1306_Test_DrawRoundRect(void);
void SSD1306_Test_FillRoundRect(void);
void SSD1306_Test_DrawLine(void);

#endif	/* OLED_SSD1306_H */

