#ifndef OLED_NHD_0216KZW_AB5_H
#define	OLED_NHD_0216KZW_AB5_H

#define NHD_STRING_BUFFER_SIZE  64

// commands
#define LCD_CLEARDISPLAY 0x01
#define LCD_RETURNHOME 0x02
#define LCD_ENTRYMODESET 0x04
#define LCD_DISPLAYCONTROL 0x08
#define LCD_CURSORSHIFT 0x10
#define LCD_FUNCTIONSET 0x28
#define LCD_SETCGRAMADDR 0x40
#define LCD_SETDDRAMADDR 0x80

// flags for display entry mode
#define LCD_ENTRYRIGHT 0x00
#define LCD_ENTRYLEFT 0x02
#define LCD_ENTRYSHIFTINCREMENT 0x01
#define LCD_ENTRYSHIFTDECREMENT 0x00

// flags for display on/off control
#define LCD_DISPLAYON 0x04
#define LCD_DISPLAYOFF 0x00
#define LCD_CURSORON 0x02
#define LCD_CURSOROFF 0x00
#define LCD_BLINKON 0x01
#define LCD_BLINKOFF 0x00

// flags for display/cursor shift
#define LCD_DISPLAYMOVE 0x08
#define LCD_CURSORMOVE 0x00
#define LCD_MOVERIGHT 0x04
#define LCD_MOVELEFT 0x00

// flags for function set
#define LCD_8BITMODE    0x10
#define LCD_4BITMODE    0x00
#define LCD_JAPANESE    0x00
#define LCD_EUROPEAN_I  0x01
#define LCD_RUSSIAN     0x02
#define LCD_EUROPEAN_II 0x03

typedef struct __OLED_CHAR_DATA {
    unsigned char display_function;
    unsigned char display_control;
    unsigned char display_mode;
    unsigned char current_line;
    unsigned char num_lines;
} OLED_CHAR_DATA;

void NHD_Init(void);
void NHD_Begin(char cols, char rows);
void NHD_Clear(void);
void NHD_Home(void);
void NHD_Display(char option);
void NHD_Blink(char option);
void NHD_Cursor(char option);
void NHD_Autoscroll(char option);
void NHD_Scroll_Display_Left(void);
void NHD_Scroll_Display_Right(void);
void NHD_Left_To_Rigtht(void);
void NHD_Right_To_Left(void);

void NHD_Create_Char(unsigned char location, unsigned char *charmap);
void NHD_Set_Cursor(unsigned char col, unsigned char row);

void NHD_Send_Data(unsigned char value);
void NHD_Send_Command(unsigned char value);

void NHD_Pulse_Enable(void);
void NHD_Write_4_Bits(unsigned char value);
void NHD_Wait_For_Ready(void);

void NHD_Write_String(const rom char *fmt, ...);

#endif	/* OLED_NHD_0216KZW_AB5_H */

