#ifndef LED_BACKPACK_H
#define	LED_BACKPACK_H

#define HT16K33_BLINK_CMD 0x80
#define HT16K33_BLINK_DISPLAYON 0x01
#define HT16K33_BLINK_OFF 0
#define HT16K33_BLINK_2HZ  1
#define HT16K33_BLINK_1HZ  2
#define HT16K33_BLINK_HALFHZ  3

#define HT16K33_CMD_BRIGHTNESS 0x0E

typedef struct {
    unsigned char i2c_address;
    unsigned char display_buffer[17];
} LED_DATA;

void LED_Init(void);
void LED_Start(void);
void LED_Set_Brightness(unsigned char c);
void LED_Blink_Rate(unsigned char c);
void LED_Write_Display(void);
void LED_Clear(void);
void LED_Draw_Colon(unsigned char c);
void LED_Write_Digit_Raw(unsigned char loc, unsigned char bitmask);
void LED_Write_Digit_Num(unsigned char loc, unsigned char num, unsigned char dot);
void LED_Write_Digit_Alpha(unsigned char loc, unsigned char alpha, unsigned char dot);
void LED_Write_Num(unsigned int i);


#endif	/* LED_BACKPACK_H */

