#ifndef INTERRUPTS_H
#define INTERRUPTS_H

// Note: As the interrupt system is currently setup, at the end
//       of each high-priority interrupt, the system will check to
//       see if the processor may be put to sleep.  This is done
//       with the call sleep_high_interrupt_if_okay() which is defined
//       in msg_queues.h -- init_queues() MUST be called prior to
//       enabling interrupts if sleep_high_interrupt_if_okay() is called!

// Initialize the interrupts
void Interrupt_Init(void);

// Enable the interrupts (high and low priority)
void Interrupt_Enable(void);
void Interrupt_Disable(void);

#endif
