#ifndef I2C_H
#define I2C_H

#define MAXI2CBUF 64

// I2C Operating Speed
#define I2C_400KHZ              0x0
#define I2C_100KHZ              0x1

// Operating State
#define I2C_IDLE                0x1
#define I2C_STARTED             0x2
#define	I2C_RCV_DATA            0x3
#define I2C_SEND_DATA           0x4
#define I2C_SEND_ADDR           0x5
#define I2C_SEND_ADDR_2         0x6
#define I2C_CHECK_ACK_SEND      0x7
#define I2C_CHECK_ACK_RECV      0x8
#define I2C_CHECK_ACK_RESTART   0x9
#define I2C_REQ_DATA            0xA
#define I2C_SEND_STOP           0xB
#define I2C_SEND_START          0xC

// Operating Mode
#define I2C_MODE_SLAVE          0x10
#define I2C_MODE_MASTER         0x11

// Master Status
#define I2C_MASTER_SEND         0x20
#define I2C_MASTER_RECV         0x21
#define I2C_MASTER_RESTART      0x22
#define I2C_MASTER_IDLE         0x23

// Return Status
#define I2C_SEND_OK             0x30
#define I2C_SEND_FAIL           0x31
#define I2C_RECV_OK             0x32
#define I2C_RECV_FAIL           0x33
#define I2C_DATA_AVAL           0x34
#define I2C_ERR_NOADDR          0x35
#define I2C_ERR_OVERRUN         0x36
#define I2C_ERR_NODATA          0x37
#define I2C_ERR_BUFFER_OVERRUN  0x38

typedef struct __I2C_DATA {
    unsigned char buffer_in[MAXI2CBUF];
    unsigned char buffer_in_len;
    unsigned char buffer_in_len_tmp;
    unsigned char buffer_in_read_ind;
    unsigned char buffer_in_write_ind;
    
    unsigned char buffer_out[MAXI2CBUF];
    unsigned char buffer_out_len;
    unsigned char buffer_out_ind;

    unsigned char operating_mode;
    unsigned char operating_state;
    unsigned char return_status;

    unsigned char master_dest_addr;
    unsigned char master_status;
    
    unsigned char slave_in_last_byte;
    unsigned char slave_sending_data;
} I2C_DATA;

void I2C_Init(void);
void I2C_Interrupt_Handler(void);
void I2C_Interrupt_Slave(void);
void I2C_Interrupt_Master(void);
void I2C_Configure_Slave(unsigned char);
void I2C_Configure_Master(unsigned char speed);
void I2C_Master_Send(unsigned char address, unsigned char length, unsigned char *msg);
void I2C_Master_Recv(unsigned char address, unsigned char length);
void I2C_Master_Restart(unsigned char address, unsigned char msg, unsigned char length);
unsigned char I2C_Get_Status(void);
unsigned char I2C_Buffer_Len(void);
unsigned char I2C_Read_Buffer(char *buffer);
unsigned char I2C_Process_Send(unsigned char);

#endif