#ifndef RTC_DS3231_H
#define	RTC_DS3231_H

#define DS3231_ADDRESS  0x68

#define DS3231_SECONDS  0x00
#define DS3231_MINUTES  0x01
#define DS3231_HOUR     0x02
#define DS3231_DAY      0x03
#define DS3231_DATE     0x04
#define DS3231_MONTH    0x05
#define DS3231_YEAR     0x06

#define DS3231_ALARM1_SECONDS   0x07
#define DS3231_ALARM1_MINUTES   0x08
#define DS3231_ALARM1_HOUR      0x09
#define DS3231_ALARM1_DAY_DATE  0x0A

#define DS3231_ALARM2_MINUTES   0x0B
#define DS3231_ALARM2_HOUR      0x0C
#define DS3231_ALARM2_DAY_DATE  0x0D

#define DS3231_CONTROL  0x0E
#define DS3231_STATUS   0x0F

void DS3231_Begin(void);

char DS3231_Get_Status(void);

void DS3231_Set_Time(char sec, char min, char hour, char day, char date,
        char month, char year, char h_mil, char h_am_pm);

void DS3231_Get_Time(char *sec, char *min, char *hour, char *day, char *date,
        char *month, char *year, char *h_mil, char *h_am_pm);

//void DS3231_Set_Alarm1(char sec, char min, char hour, char date, bit mil, bit am_pm, bit dt_dy);
//void DS3231_Set_Alarm2(char min, char hour, char date, bit mil, bit am_pm, bit dt_dy);

#endif

