#ifndef OLED_SSD1331_H
#define	OLED_SSD1331_H

#define SSD1331_LCDWIDTH        96
#define SSD1331_LCDHEIGHT       64
//#define SSD1331_STRING_BUFFER_SIZE          64

// Select one of these defines to set the pixel color order
#define SSD1331_COLORORDER_RGB
// #define SSD1331_COLORORDER_BGR

// SSD1331 Commands
#define SSD1331_CMD_DRAWLINE 		0x21
#define SSD1331_CMD_DRAWRECT 		0x22
#define SSD1331_CMD_CLEARWINDOW         0x25
#define SSD1331_CMD_FILL                0x26
#define SSD1331_CMD_SETCOLUMN 		0x15
#define SSD1331_CMD_SETROW    		0x75
#define SSD1331_CMD_CONTRASTA 		0x81
#define SSD1331_CMD_CONTRASTB 		0x82
#define SSD1331_CMD_CONTRASTC		0x83
#define SSD1331_CMD_MASTERCURRENT 	0x87
#define SSD1331_CMD_SETREMAP 		0xA0
#define SSD1331_CMD_STARTLINE 		0xA1
#define SSD1331_CMD_DISPLAYOFFSET 	0xA2
#define SSD1331_CMD_NORMALDISPLAY 	0xA4
#define SSD1331_CMD_DISPLAYALLON  	0xA5
#define SSD1331_CMD_DISPLAYALLOFF 	0xA6
#define SSD1331_CMD_INVERTDISPLAY 	0xA7
#define SSD1331_CMD_SETMULTIPLEX  	0xA8
#define SSD1331_CMD_SETMASTER 		0xAD
#define SSD1331_CMD_DISPLAYOFF 		0xAE
#define SSD1331_CMD_DISPLAYON     	0xAF
#define SSD1331_CMD_POWERMODE 		0xB0
#define SSD1331_CMD_PRECHARGE 		0xB1
#define SSD1331_CMD_CLOCKDIV 		0xB3
#define SSD1331_CMD_PRECHARGEA 		0x8A
#define SSD1331_CMD_PRECHARGEB 		0x8B
#define SSD1331_CMD_PRECHARGEC 		0x8C
#define SSD1331_CMD_PRECHARGELEVEL 	0xBB
#define SSD1331_CMD_VCOMH 		0xBE

// Color definitions
#define	SSD1331_BLACK           0x0000
#define	SSD1331_BLUE            0x001F
#define	SSD1331_RED             0xF800
#define	SSD1331_GREEN           0x07E0
#define SSD1331_CYAN            0x07FF
#define SSD1331_MAGENTA         0xF81F
#define SSD1331_YELLOW          0xFFE0
#define SSD1331_WHITE           0xFFFF

typedef struct {
    int WIDTH, HEIGHT; // raw display size
    int _width, _height; // size depending on rotation
    int cursor_x, cursor_y;
    unsigned int textcolor, textbgcolor;
    char textsize;
    char rotation;
    char wrap; // If set, wrap text at right side
} SSD1331_DATA;

// Misc functions
int SSD1331_Abs(int i);
void SSD1331_Swap(int *a, int *b);
unsigned int SSD1331_Color565(char r, char g, char b);

// Core functions
void SSD1331_Init(SSD1331_DATA *data);
void SSD1331_Begin(void);
void SSD1331_GoTo(int x, int y);

void SSD1331_Command(char c);
void SSD1331_Data(char d);

// Display functions
void SSD1331_Clear_Display(void);

void SSD1331_Draw_Pixel(int x, int y, unsigned int color);
void SSD1331_Draw_Line(int x0, int y0, int x1, int y1, unsigned int color);
void SSD1331_Draw_Fast_VLine(int x, int y, int h, unsigned int color);
void SSD1331_Draw_Fast_HLine(int x, int y, int w, unsigned int color);
void SSD1331_Draw_Rect(int x0, int y0, int x1, int y1, unsigned int color);
void SSD1331_Fill_Rect(int x0, int y0, int x1, int y1, unsigned int color);

void SSD1331_Draw_Circle(int x0, int y0, int r, unsigned int color);
void SSD1331_Draw_Circle_Helper(int x0, int y0, int r, char cornername, unsigned int color);
void SSD1331_Fill_Circle(int x0, int y0, int r, unsigned int color);
void SSD1331_Fill_Circle_Helper(int x0, int y0, int r, char cornername, int delta, unsigned int color);

void SSD1331_Draw_Triangle(int x0, int y0, int x1, int y1, int x2, int y2, unsigned int color);
void SSD1331_Fill_Triangle(int x0, int y0, int x1, int y1, int x2, int y2, unsigned int color);
void SSD1331_Draw_Round_Rect(int x0, int y0, int w, int h, int radius, unsigned int color);
void SSD1331_Fill_Round_Rect(int x0, int y0, int w, int h, int radius, unsigned int color);

void SSD1331_Draw_Bitmap(int x, int y, const char *bitmap, int w, int h, unsigned int color);
void SSD1331_Draw_Char(int x, int y, char c, unsigned int color, unsigned int bg, char size);

void SSD1331_Write(char c);
void SSD1331_Write_String(char *msg, char length);
//void SSD1331_Write_String(const rom char *fmt, ...);
//void SSD1331_Append_String(const rom char *fmt, ...);

void SSD1331_Set_Cursor(int x, int y);
void SSD1331_Set_Text_Color(unsigned int c);
void SSD1331_Set_Text_Color_BG(unsigned int c, unsigned int bg);
void SSD1331_Set_Text_Size(char s);
void SSD1331_Set_Text_Wrap(char w);
void SSD1331_Set_Rotation(char r);

// Test functions
void SSD1331_Test_DrawLines(unsigned int color);
void SSD1331_Test_DrawRect(unsigned int color);
void SSD1331_Test_FillRect(unsigned int color1, unsigned int color2);
void SSD1331_Test_DrawCircle(unsigned int radius, unsigned int color);
void SSD1331_Test_FillCircle(unsigned int radius, unsigned int color);
void SSD1331_Test_DrawTria(void);
void SSD1331_Test_DrawRoundRect(void);
void SSD1331_Test_MediaButtons(void);
void SSD1331_Test_Pattern(void);

#endif	/* OLED_SSD1331_H */

