#ifndef LED_BACKPACK_H
#define	LED_BACKPACK_H

#define HT16K33_ADDRESS 0x70

#define HT16K33_BLINK_CMD 0x80
#define HT16K33_BLINK_DISPLAYON 0x01
#define HT16K33_BLINK_OFF 0
#define HT16K33_BLINK_2HZ  1
#define HT16K33_BLINK_1HZ  2
#define HT16K33_BLINK_HALFHZ  3

#define HT16K33_CMD_BRIGHTNESS 0x0E

typedef struct {
    char i2c_address;
    char display_buffer[17];
} LED_DATA;

void LED_Init(LED_DATA *data);
void LED_Start(void);
void LED_Set_Brightness(char c);
void LED_Blink_Rate(char c);
void LED_Write_Display(void);
void LED_Clear(void);
void LED_Draw_Colon(char c);
void LED_Write_Digit_Raw(char loc, char bitmask);
void LED_Write_Digit_Num(char loc, char num, char dot);
void LED_Write_Digit_Alpha(char loc, char alpha, char dot);
void LED_Write_Num(int i);


#endif	/* LED_BACKPACK_H */

