#include "display_led_HT16K33.h"
#include "base_I2C.h"

static const char numbertable[] = {
    0x3F /* 0 */,
    0x06 /* 1 */,
    0x5B /* 2 */,
    0x4F /* 3 */,
    0x66 /* 4 */,
    0x6D /* 5 */,
    0x7D, /* 6 */
    0x07, /* 7 */
    0x7F, /* 8 */
    0x6F, /* 9 */
};

static const char alphatable[] = {
    0x77, /* a */
    0x7C, /* b */
    0x39, /* C */
    0x5E, /* d */
    0x79, /* E */
    0x71, /* F */
};

static LED_DATA *led_data_p;

void LED_Init(LED_DATA *data) {
    led_data_p = data;
    
    led_data_p->i2c_address = HT16K33_ADDRESS;
}

void LED_Start() {
    char c = 0x21;     // Cmd to turn on oscillator
    
    I2C_Master_Send(led_data_p->i2c_address, 1, &c);
    char result = I2C_Get_Status();
    while (!result) {
        result = I2C_Get_Status();
    }

    LED_Blink_Rate(HT16K33_BLINK_OFF);
    LED_Set_Brightness(15);  // Max brightness
    LED_Clear();
    LED_Write_Display();
}

void LED_Set_Brightness(char c) {
    if (c > 15) c = 15;
    c |= 0xE0;

    I2C_Master_Send(led_data_p->i2c_address, 1, &c);
    char result = I2C_Get_Status();
    while (!result) {
        result = I2C_Get_Status();
    }
}

void LED_Blink_Rate(char c) {
    char buffer;

    if (c > 3) c = 0;

    buffer = HT16K33_BLINK_CMD | HT16K33_BLINK_DISPLAYON | (c << 1);

    I2C_Master_Send(led_data_p->i2c_address, 1, &buffer);
    buffer = I2C_Get_Status();
    while (!buffer) {
        buffer = I2C_Get_Status();
    }
}

void LED_Write_Display() {
    led_data_p->display_buffer[0] = 0x00;  // Start at address 0x00
    I2C_Master_Send(led_data_p->i2c_address, 17, led_data_p->display_buffer);

    char result = I2C_Get_Status();
    while (!result) {
        result = I2C_Get_Status();
    }
}

void LED_Clear() {
    for (char c = 0; c < 17; c++) {
        led_data_p->display_buffer[c] = 0;
    }
}

void LED_Draw_Colon(char c) {
    if (c) {
        led_data_p->display_buffer[5] = 0xFF;
    } else {
        led_data_p->display_buffer[5] = 0;
    }
}

void LED_Write_Digit_Raw(char loc, char bitmask) {
    if (loc > 4) return;
    led_data_p->display_buffer[(loc<<1)+1] = bitmask;
}

void LED_Write_Digit_Num(char loc, char num, char dot) {
    if (loc > 4) return;
    if (loc > 1) loc++;
    LED_Write_Digit_Raw(loc, numbertable[num] | dot << 7);
}

void LED_Write_Digit_Alpha(char loc, char alpha, char dot) {
    if (loc > 4) return;
    if (loc > 1) loc++;
    LED_Write_Digit_Raw(loc, alphatable[alpha] | dot << 7);
}

void LED_Write_Num(int i) {
    LED_Write_Digit_Num(0, (i%10000)/1000, 0);
    LED_Write_Digit_Num(1, (i%1000)/100, 0);
    LED_Write_Digit_Num(2, (i%100)/10, 0);
    LED_Write_Digit_Num(3, i%10, 0);

    if (i < 10) {
        LED_Write_Digit_Raw(0, 0);
        LED_Write_Digit_Raw(1, 0);
        LED_Write_Digit_Raw(3, 0);
    } else if (i < 100) {
        LED_Write_Digit_Raw(0, 0);
        LED_Write_Digit_Raw(1, 0);
    } else if (i < 1000) {
        LED_Write_Digit_Raw(0, 0);
    }
    LED_Write_Display();
}