#ifndef DEFINES_H
#define	DEFINES_H

#define _XTAL_FREQ 48000000

#define UART1_RX_TO_BUFFER
//#define UART1_RX_TO_XBEE

#define _DEBUG

// <editor-fold defaultstate="collapsed" desc="I2C Addresses">
// HT16K33_ADDRESS          0x70
// L3GD20_ADDRESS           0x6B
// BMP085_I2CADDR           0x77
// TSL2561_ADDR_FLOAT       0x39
// PN532_I2C_ADDRESS        0x24
// LSM303_MAG_ADDRESS       0x1E
// LSM303_ACC_ADDRESS       0x18
// </editor-fold>

// <editor-fold defaultstate="expanded" desc="Test Cases">
//#define _TEST_UART
//#define _TEST_I2C_MASTER
//#define _TEST_I2C_SLAVE
//#define _TEST_SPI
#define _TEST_SPI_DMA
//#define _TEST_ADC
//#define _TEST_TIMER1_RTC
//#define _TEST_NFC
//#define _TEST_LUX
//#define _TEST_BMP
//#define _TEST_GYRO
//#define _TEST_ACCEL
//#define _TEST_RTC
//#define _TEST_LED_BACKPACK
//#define _TEST_SSD1306_OLED
//#define _TEST_SSD1331_OLED
//#define _TEST_XBEE

//#define _TEST_OLED_CHAR
//#define _TEST_NFC_TO_SSD1306_OLED
//#define _TEST_LUX_TO_CHAR_OLED
//#define _TEST_RTC_TO_LED_BACKPACK_CHAR_OLED
//#define _TEST_AHRS
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc="Debug Redirection">
#ifdef _DEBUG
#define DBG_PRINT_MAIN UART1_WriteS
#define DBG_PRINT_UART UART1_WriteS
#define DBG_PRINT_I2C UART1_WriteS
#define DBG_PRINT_SPI UART1_WriteS
#define DBG_PRINT_XBEE UART1_WriteS
#define DBG_PRINT_PORTB_INT
#define DBG_PRINT_INT
#define DBG_PRINT_LUX
#define DBG_PRINT_BMP
#else
#define DBG_PRINT_MAIN
#define DBG_PRINT_UART
#define DBG_PRINT_I2C
#define DBG_PRINT_SPI
#define DBG_PRINT_XBEE
#define DBG_PRINT_PORTB_INT
#define DBG_PRINT_INT
#define DBG_PRINT_LUX
#define DBG_PRINT_BMP
#endif
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc="Pin Allocations">
#define UART1_RX_TRIS           TRISCbits.TRISC7
#define UART1_TX_TRIS           TRISCbits.TRISC6

#define I2C_CLK_TRIS            TRISCbits.TRISC3
#define I2C_DAT_TRIS            TRISCbits.TRISC4

#define LED_BLUE_TRIS           TRISCbits.TRISC5
#define LED_BLUE_LAT            LATCbits.LATC5
#define LED_RED_TRIS            TRISCbits.TRISC2
#define LED_RED_LAT             LATCbits.LATC2

#define ADC_AN0_TRIS            TRISAbits.TRISA0
#define ADC_AN1_TRIS            TRISAbits.TRISA1
#define ADC_AN2_TRIS            TRISAbits.TRISA2

#define XBEE_CTS_TRIS           TRISBbits.TRISB0
#define XBEE_CTS_LAT            LATBbits.LATB0
#define XBEE_CTS_PORT           PORTBbits.RB0
#define XBEE_RTS_TRIS           TRISBbits.TRISB1
#define XBEE_RTS_LAT            LATBbits.LATB1

#define SPI_MOSI_TRIS           TRISBbits.TRISB0
#ifndef SPI2_WRITE_ONLY
#define SPI_MISO_TRIS           TRISBbits.TRISB0
#endif
#define SPI_CLK_TRIS            TRISAbits.TRISA0
#define SPI_DC_SELECT_TRIS      TRISAbits.TRISA1
#define SPI_DC_SELECT_LAT       LATAbits.LATA1
#define SPI_RESET_TRIS          TRISAbits.TRISA2
#define SPI_RESET_LAT           LATAbits.LATA2
#define SPI_SLAVE_SELECT_TRIS   TRISAbits.TRISA3
#define SPI_SLAVE_SELECT_LAT    LATAbits.LATA3

#define PARALLEL_RS_TRIS        TRISBbits.TRISB7
#define PARALLEL_RS_LAT         LATBbits.LATB7
#define PARALLEL_RW_TRIS        TRISBbits.TRISB6
#define PARALLEL_RW_LAT         LATBbits.LATB6
#define PARALLEL_EN_TRIS        TRISBbits.TRISB5
#define PARALLEL_EN_LAT         LATBbits.LATB5
#define PARALLEL_D4_TRIS        TRISBbits.TRISB4
#define PARALLEL_D4_LAT         LATBbits.LATB4
#define PARALLEL_D5_TRIS        TRISBbits.TRISB3
#define PARALLEL_D5_LAT         LATBbits.LATB3
#define PARALLEL_D6_TRIS        TRISBbits.TRISB2
#define PARALLEL_D6_LAT         LATBbits.LATB2
#define PARALLEL_D7_TRIS        TRISBbits.TRISB1
#define PARALLEL_D7_LAT         LATBbits.LATB1
#define PARALLEL_BUSY_TRIS      TRISBbits.TRISB1
#define PARALLEL_BUSY_PORT      PORTBbits.RB1

#define NFC_IRQ_TRIS            TRISAbits.TRISA5
#define NFC_IRQ_PORT            PORTAbits.RA5
//#define NFC_RESET_TRIS          TRISCbits.TRISC2
//#define NFC_RESET_LAT           LATCbits.LATC2

// PPS bindings (RP Pins)
#define PPS_SPI2_CLK_IN         0       // A0
#define PPS_SPI2_CLK_OUT        RPOR0   // A0
#define PPS_SPI2_MOSI           RPOR3   // B0
#ifndef SPI2_WRITE_ONLY
#define PPS_SPI2_MISO           3       // NA
#endif

//#define PPS_UART2_RX            5
//#define PPS_UART2_TX            RPOR6
// </editor-fold>

#endif	/* DEFINES_H */

