#include <xc.h>
#include <delays.h>
#include "defines.h"
#include "base_TIMERS.h"

void Timer1_Init(void) {
    T1CONbits.TMR1CS = 0x2;     // Clock source using T1OSC and T1CLK pins
    T1CONbits.RD16 = 0x1;       // Configure for 16-bit read/writes
    T1CONbits.T1OSCEN = 0x1;    // Enable crystal driver
    PIE1bits.TMR1IE = 0x1;      // Enable interrupt

    // Non-applicable settings
    T1CONbits.T1CKPS = 0x0;     // 1:1 prescale value
    T1CONbits.NOT_T1SYNC = 0x1; // No external sync
    T1GCONbits.TMR1GE = 0x0;    // Disable gate control
}

void Timer1_Enable(void) {
    T1CONbits.TMR1ON = 1;
}

void Timer1_Disable(void) {
    T1CONbits.TMR1ON = 0;
}

void Timer1_Interrupt_Handler(void) {
#ifdef _TEST_TIMER1_RTC
    TMR1H = 0x7F;
    TMR1L = 0xFF;
    LED_BLUE_LAT = 1;
    LED_RED_LAT = 1;
    Delay10KTCYx(255);
    LED_BLUE_LAT = 0;
    LED_RED_LAT = 0;
#endif
}