#ifndef SPI_H
#define	SPI_H

#define MAXSPIBUF 64

#define SPI2_WRITE_ONLY

// Option to use interrupt. If interrupt are used, SPI write does not block but
//  there is a longer delay between reading/writing data
//#define SPI2_USE_INTERRUPT

// SPI speed selection
#define SPI2_FOSC_TMR2      0b0011
#define SPI2_FOSC_64        0b0010
#define SPI2_FOSC_16        0b0001
#define SPI2_FOSC_8         0b1010
#define SPI2_FOSC_4         0b0000

typedef struct {
#ifndef SPI2_WRITE_ONLY
    char buffer_in[MAXSPIBUF];
    char buffer_in_read_ind;
    char buffer_in_write_ind;
    char buffer_in_len;
#endif

    char buffer_out[MAXSPIBUF];
    char buffer_out_ind;
    char buffer_out_len;
} SPI_DATA;

void SPI2_Init(SPI_DATA *data, char speed);
void SPI2_Write(char *msg, unsigned int length);
void SPI2_Write_Repeat(char c, unsigned int length);
#ifndef SPI2_WRITE_ONLY
void SPI2_Recv_Interrupt_Handler(void);
void SPI2_Read(char length);
char SPI2_Buffer_Len(void);
char SPI2_Read_Buffer(char *buffer);
#endif

void SPI2_DMA_Init(void);
void SPI2_DMA_Start(unsigned int length, void *TXADDR, void *RXADDR);

#endif	/* SPI_H */

