#include <xc.h>
#include "defines.h"
#include "base_INTERRUPTS.h"
#include "base_UART.h"
#include "base_I2C.h"
#include "base_TIMERS.h"

void Interrupt_Init() {
    // Peripheral base_INTERRUPTS.can have their priority set to high or low
    // Decide on the priority of the enabled peripheral interrupts (0 is low, 1 is high)

    // High priority interrupts
    IPR1bits.RC1IP = 1;     // USART1 RX interrupt
    IPR1bits.TX1IP = 1;     // USART1 TX interrupt
//    IPR3bits.RC2IP = 1;     // USART2 RX interrupt
    IPR1bits.SSPIP = 1;     // I2C interrupt
//    IPR3bits.SSP2IP = 1;    // MSSP2 (SPI2) interrupt

    // Low priority interrupts
//    INTCON2bits.TMR0IP = 0; // Timer0 interrupt
    IPR1bits.TMR1IP = 0;    // Timer1 interrupt
//    IPR2bits.TMR3IP = 0; // Timer 3 interrupt
//    IPR1bits.ADIP = 0;      // ADC interupt
//    INTCON2bits.RBIP = 0;   // Port B interrupt
//    INTCON3bits.INT1IP = 0; // INT1 interrupt
    
    // Enable Port B interrupt
//    INTCONbits.RBIE = 1;
    // Enable interrupt for INT1
//    INTCON3bits.INT1IE = 1;
}

void Interrupt_Enable() {
    // Peripheral base_INTERRUPTS.can have their priority set to high or low.
    // Enable both high-priority interrupts and low-priority interrupts
    RCONbits.IPEN = 1;
    INTCONbits.GIEH = 1;
    INTCONbits.GIEL = 1;
}

void Interrupt_Disable() {
    RCONbits.IPEN = 0;
    INTCONbits.GIEH = 0;
    INTCONbits.GIEL = 0;
}

void interrupt InterruptHandlerHigh(void) {
    // We need to check the interrupt flag of each enabled high-priority interrupt to
    //  see which device generated this interrupt.  Then we can call the correct handler.

//    // Check to see if we have an SPI2 interrupt
//    if (PIR3bits.SSP2IF) {
//        // Call the handler
//        SPI2_Recv_Interrupt_Handler();
//
//        // Clear the interrupt flag
//        PIR3bits.SSP2IF = 0;
//
//        return;
//    }

    // Check to see if we have an I2C interrupt
    if (PIR1bits.SSPIF) {

        // Call the handler
        I2C_Interrupt_Handler();

        // Clear the interrupt flag
        PIR1bits.SSPIF = 0;

        return;
    }

    // Check to see if we have an interrupt on USART1 RX
    if (PIR1bits.RC1IF) {
        // Call the interrupt handler
        UART1_Recv_Interrupt_Handler();

        // Clear the interrupt flag
        PIR1bits.RC1IF = 0;

        return;
    }

#ifndef _DEBUG  // Disable UART1 TX interrupt for debug mode (using printf)
    // Check to see if we have an interrupt on USART1 TX
    if (PIR1bits.TX1IF) {
        // Call the interrupt handler
        UART1_Send_Interrupt_Handler();

        // Clear the interrupt flag
        PIR1bits.TX1IF = 0;

        return;
    }
#endif

//    // Check to see if we have an interrupt on USART2 RX
//    if (PIR3bits.RC2IF) {
//        DBG_PRINT_INT("INT: UART2 RX\r\n");
//        // Call the interrupt handler
//        uart_2_recv_interrupt_handler();
//
//        // Clear the interrupt flag
//        PIR3bits.RC2IF = 0;
//    }
}

void interrupt low_priority InterruptHandlerLow() {
//    // Check to see if we have an interrupt on INT1
//    if (INTCON3bits.INT1IF) {
//        DBG_PRINT_INT("INT: INT1\r\n");
//        int1_interrupt_handler();
//
//        INTCON3bits.INT1IF = 0;
//    }

//    // Check to see if we have an interrupt on any port B inputs <4:7>
//    if (INTCONbits.RBIF) {
//        DBG_PRINT_INT("INT: Port B\r\n");
//        port_b_int_interrupt_handler();
//
//        INTCONbits.RBIF = 0;
//    }

//    // Check to see if we have an interrupt on timer 0
//    if (INTCONbits.TMR0IF) {
//        DBG_PRINT_INT("INT: Timer 0\r\n");
//        // Call the handler
//        timer0_interrupt_handler();
//
//        // Clear this interrupt flag
//        INTCONbits.TMR0IF = 0;
//    }

    // Check to see if we have an interrupt on timer 1
    if (PIR1bits.TMR1IF) {
        // Call the interrupt handler
        Timer1_Interrupt_Handler();

        // Clear the interrupt flag
        PIR1bits.TMR1IF = 0;
    }

//    // Check to see if we have an interrupt on timer 3
//    if (PIR2bits.TMR3IF) {
//        DBG_PRINT_INT("INT: Timer 3\r\n");
//        timer3_interrupt_handler();
//
//        PIR2bits.TMR3IF = 0;
//    }

//    // Check to see if we have an interrupt on ADC
//    if (PIR1bits.ADIF) {
//        // Call the interrupt handler
//        ADC_Interrupt_Handler();
//
//        // Clear the interrupt flag
//        PIR1bits.ADIF = 0;
//    }
}