#ifndef ADC_H
#define ADC_H

#define ADC_CHANNEL_AN0     0b0000
#define ADC_CHANNEL_AN1     0b0001
#define ADC_CHANNEL_AN2     0b0010
#define ADC_CHANNEL_AN3     0b0011
#define ADC_CHANNEL_AN4     0b0100
#define ADC_CHANNEL_AN5     0b0101
#define ADC_CHANNEL_AN6     0b0110
#define ADC_CHANNEL_AN7     0b0111
#define ADC_CHANNEL_AN8     0b1000
#define ADC_CHANNEL_AN9     0b1001
#define ADC_CHANNEL_AN10    0b1010
#define ADC_CHANNEL_AN11    0b1011
#define ADC_CHANNEL_AN12    0b1100
#define ADC_CHANNEL_VDDCORE 0b1110
#define ADC_CHANNEL_ABG     0b1111

#define ADC_TAD_20  0b111
#define ADC_TAD_16  0b110
#define ADC_TAD_12  0b101
#define ADC_TAD_8   0b100
#define ADC_TAD_6   0b011
#define ADC_TAD_4   0b010
#define ADC_TAD_2   0b001
#define ADC_TAD_0   0b000

#define ADC_FOSC_64_     0b110
#define ADC_FOSC_32_     0b010
#define ADC_FOSC_16_     0b101
#define ADC_FOSC_8_      0b001
#define ADC_FOSC_4_      0b100
#define ADC_FOSC_2_      0b000
#define ADC_FOSC_FRC_    0b011

typedef struct __ADC_DATA {
    char last_channel;
    unsigned int result;
} ADC_DATA;

void ADC_Init(ADC_DATA *data, char TAD, char FOSC);
void ADC_Start(char channel);
void ADC_Stop(void);
void ADC_Interrupt_Handler(void);
char ADC_Get_Result(unsigned int *ret);

#endif