#ifndef MAIN_H
#define	MAIN_H

#define UART_RX_TRIS TRISCbits.TRISC5
#define UART_TX_TRIS TRISCbits.TRISC4
#define UART_CTS_TRIS TRISCbits.TRISC3
#define UART_CTS_LAT LATCbits.LATC3
#define UART_RTS_TRIS TRISCbits.TRISC6
#define UART_RTS_LAT LATCbits.LATC6

#define I2C_CLK_TRIS TRISBbits.TRISB6
#define I2C_DAT_TRIS TRISBbits.TRISB4

#define LED_R_TRIS TRISCbits.TRISC0
#define LED_R_LAT LATCbits.LATC0

#define LED_G_TRIS TRISCbits.TRISC1
#define LED_G_LAT LATCbits.LATC1

#define LED_B_TRIS TRISCbits.TRISC2
#define LED_B_LAT LATCbits.LATC2

// Active low reset
#define BLE_RESET_TRIS TRISCbits.TRISC7
#define BLE_RESET_LAT LATCbits.LATC7

#define ADDRESS_GYRO 0x6B
#define ADDRESS_ACCL 0x19
#define ADDRESS_MAGN 0x1E
#define ADDRESS_LIPO 0x36

#define _XTAL_FREQ 32000000

#define LED_R_MAX_BRIGHTNESS 5
#define LED_G_MAX_BRIGHTNESS 20
#define LED_B_MAX_BRIGHTNESS 30 // Dont set this past 100!

#endif	/* MAIN_H */

// <editor-fold defaultstate="collapsed" desc="Pinouts">
/*
1/RA3 - MCLR
2/RC5 - UART RX
3/RC4 - UART TX
4/RC3 - UART CTS
5/RC6 - UART RTS
6/RC7 - BLE RESET
7/RB7 - Acc Interrupt 1
8/RB6 - I2C SCL
9/RB5 - Mag Interrupt
10/RB4 - I2C SDA
11/RC2 - BLE SLEEP
12/RC1 - LED
13/RC0 - BLE Mode Toggle
14/RA2 - Gyro Interrupt 2
15/RA1 - ICSPCLK
16/RA0 - ISCLDAT
17/VSS - GND
18/VDD - VDD
19/RA5 - T1 OSO
20/RA4 - T1 OSO
*/
// </editor-fold>
