#include <xc.h>
#include <string.h>
#include "main.h"
#include "TIMER.h"
#include "INTERRUPT.h"
#include "UART.h"
#include "I2C.h"
#include "L3G.h"
#include "LSM303.h"
#include "RN-42.h"
#include "MAX17040.h"

// <editor-fold defaultstate="collapsed" desc="Configuration Bits">
// CONFIG1
#pragma config FOSC = INTOSC    // Oscillator Selection (INTOSC oscillator: I/O function on CLKIN pin)
#pragma config WDTE = OFF       // Watchdog Timer Enable (WDT disabled)
#pragma config PWRTE = OFF      // Power-up Timer Enable (PWRT disabled)
#pragma config MCLRE = ON       // MCLR Pin Function Select (MCLR/VPP pin function is MCLR)
#pragma config CP = OFF         // Flash Program Memory Code Protection (Program memory code protection is disabled)
#pragma config CPD = OFF        // Data Memory Code Protection (Data memory code protection is disabled)
#pragma config BOREN = ON       // Brown-out Reset Enable (Brown-out Reset enabled)
#pragma config CLKOUTEN = OFF   // Clock Out Enable (CLKOUT function is disabled. I/O or oscillator function on the CLKOUT pin)
#pragma config IESO = ON        // Internal/External Switchover (Internal/External Switchover mode is enabled)
#pragma config FCMEN = ON       // Fail-Safe Clock Monitor Enable (Fail-Safe Clock Monitor is enabled)

// CONFIG2
#pragma config WRT = OFF        // Flash Memory Self-Write Protection (Write protection off)
#pragma config PLLEN = ON       // PLL Enable (4x PLL disabled)
#pragma config STVREN = ON      // Stack Overflow/Underflow Reset Enable (Stack Overflow or Underflow will cause a Reset)
#pragma config BORV = LO        // Brown-out Reset Voltage Selection (Brown-out Reset Voltage (Vbor), low trip point selected.)
#pragma config LVP = OFF        // Low-Voltage Programming Enable (High-voltage on MCLR/VPP must be used for programming)
// </editor-fold>

UART_DATA uart_data;
I2C_DATA i2c_data;

char LED_R_ON = 0;
char LED_G_ON = 0;
char LED_B_ON = 0;
char timer_2_pwm = 0;
char connected = 0;

void Error(char ID) {
    while(1) {
        for (char i = 0; i < ID; i++) {
            LED_R_ON = 1;
            __delay_ms(120);
            LED_R_ON = 0;
            __delay_ms(150);
        }
        __delay_ms(1000);
    }
}

void Startup_Check(void) {
    char buffer[20];
    char result, length;

//    BLE_RESET_LAT = 0;
//    __delay_ms(3000);
//    BLE_RESET_LAT = 1;
//    __delay_ms(200);

//    // Check BLE Module
//    length = UART_Read(buffer);
//    if (memcmp(buffer, "\r\nBR-LE4.0-S2\r\n", 15)) {
//        Error(1);
//    }
//    UART_Write("AT\r", 3);
//    __delay_ms(10);
//    length = UART_Read(buffer);
//    if (memcmp(buffer, "\r\nOK\r\n", 6)) {
//        Error(1);
//    }

    // Check Battery Gauge
    I2C_Master_Restart(ADDRESS_LIPO, 0x0C, 2);
    do {
        result = I2C_Get_Status();
    } while (!result);
    if ((result != I2C_SEND_OK) && (result != I2C_RECV_OK)) {
        Error(2);
    }
    length = I2C_Read_Buffer(buffer);
    if ((buffer[0] != 0x97) || (buffer[1] != 0x00) || (length != 2)) {
        Error(2);
    }

    // Check Gyroscope
    I2C_Master_Restart(ADDRESS_GYRO, 0x0F, 1);
    do {
        result = I2C_Get_Status();
    } while (!result);
    if ((result != I2C_SEND_OK) && (result != I2C_RECV_OK)) {
        Error(3);
    }
    length = I2C_Read_Buffer(buffer);
    if ((buffer[0] != 0xD4) || (length != 1)) {
        Error(3);
    }

    // Check Accelerometer
    I2C_Master_Restart(ADDRESS_ACCL, 0x20, 1);
    do {
        result = I2C_Get_Status();
    } while (!result);
    if ((result != I2C_SEND_OK) && (result != I2C_RECV_OK)) {
        Error(4);
    }
    length = I2C_Read_Buffer(buffer);
    if ((buffer[0] != 0x07) || (length != 1)) {
        Error(4);
    }

    // Check Magnometer
    I2C_Master_Restart(ADDRESS_MAGN, 0x0A, 1);
    do {
        result = I2C_Get_Status();
    } while (!result);
    if ((result != I2C_SEND_OK) && (result != I2C_RECV_OK)) {
        Error(4);
    }
    length = I2C_Read_Buffer(buffer);
    if ((buffer[0] != 0x48) || (length != 1)) {
        Error(4);
    }
}

void Timer_2_Callback(void) {
    // Here we manually 'PWM' the LEDs
    // Note: this is terribly inefficient but we need to do this
    //  otherwise we will blow out the blue LED (max 10mA)
    if (timer_2_pwm == 0) {
        LED_R_LAT = (LED_R_ON) ? 0 : 1;
        LED_G_LAT = (LED_G_ON) ? 0 : 1;
        LED_B_LAT = (LED_B_ON) ? 0 : 1;
    }
    if (timer_2_pwm == LED_R_MAX_BRIGHTNESS) {
        LED_R_LAT = 1;
    }
    if (timer_2_pwm == LED_G_MAX_BRIGHTNESS) {
        LED_G_LAT = 1;
    }
    if (timer_2_pwm == LED_B_MAX_BRIGHTNESS) {
        LED_B_LAT = 1;
    }
    timer_2_pwm++;
}

void Timer_1_Callback(void) {
//    int A_X,A_Y,A_Z;
//    int G_X,G_Y,G_Z;
//    int M_X,M_Y,M_Z;

//    LSM303_Read_Accl(&A_X, &A_Y, &A_Z);
//    L3G_Read_Gyro(&G_X, &G_Y, &G_Z);
//    LSM303_Read_Magn(&output[6], &output[7], &output[8]);

//    UART_Write("Hello", 5);
}

int main() {

    OSCCON = 0xF0; // Software PLL enabled, 32MHz
    ANSELA = 0;
    ANSELB = 0;
    ANSELC = 0;

    LED_R_TRIS = 0;
    LED_R_LAT = 1;
    LED_G_TRIS = 0;
    LED_G_LAT = 1;
    LED_B_TRIS = 0;
    LED_B_LAT = 1;

    BLE_RESET_TRIS = 0;
    BLE_RESET_LAT = 1;

    UART_CTS_TRIS = 1;
    UART_RTS_TRIS = 0;
    UART_RTS_LAT = 0;

    // Initialize all peripherals
    TIMER_1_Init(&Timer_1_Callback);
    TIMER_2_Init(&Timer_2_Callback);
    UART_Init(&uart_data);
    I2C_Init(&i2c_data);
    INTERRUPT_Init();

    I2C_Configure_Master(I2C_400KHZ);
    INTERRUPT_Enable();
//    TIMER_1_Start();
    TIMER_2_Start();

    // A small delay is needed for the sensors to start up
    __delay_ms(1000);

    // Run a check to ensure that all sensors are properly connected
    Startup_Check();

    // Initialze the sensors
    L3G_Init();
    LSM303_Init();
    RN42_Init();
    MAX17040_Init();

    char output[21] = {0};
    output[20] = '\n';
    
//    char len, buffer[30];

    LED_B_ON = 1;
    
    while(1) {
        __delay_ms(10);

//        len = UART_Read(buffer);
//        if (len != 0) {
//            if (!strncmp(buffer, "!CONNECT", 8)) {
//                connected = 1;
//                LED_G_ON = 1;
//            }
//            if (!strncmp(buffer, "!DISCONNECT", 11)) {
//                connected = 0;
//                LED_G_ON = 0;
//            }
//        }

//        if (connected) {
            LSM303_Read_Accl(&output[0], &output[1], &output[2], &output[3], &output[4], &output[5]);
            L3G_Read_Gyro(&output[6], &output[7], &output[8], &output[9], &output[10], &output[11]);
            LSM303_Read_Magn(&output[12], &output[13], &output[14], &output[15], &output[16], &output[17]);
            MAX17040_Read_Batt(&output[18], &output[19]);

            UART_Write((char *)&output[0], 21);
//        }

//        LED_B_ON = 0;
//        LED_R_ON = 1;
//        __delay_ms(250);
//        LED_R_ON = 0;
//        LED_G_ON = 1;
//        __delay_ms(250);
//        LED_G_ON = 0;
//        LED_B_ON = 1;
//        __delay_ms(250);
    }
}