#ifndef UART_H
#define UART_H

#define UART_BUFFER_SIZE 30

typedef struct {
    char buffer_in[UART_BUFFER_SIZE];
    char buffer_in_read_ind;
    char buffer_in_write_ind;
    char buffer_in_len;

    char buffer_out[UART_BUFFER_SIZE];
    char buffer_out_ind;
    char buffer_out_len;
} UART_DATA;

void UART_Init(UART_DATA *data);
void UART_Write(char *data, char length);
char UART_Read(char *buffer);

void UART_TX_Interrupt_Handler(void);
void UART_RX_Interrupt_Handler(void);

#endif  /* UART_H */

