#include <xc.h>
#include "main.h"
#include "TIMER.h"

void (*timer_1_callback)(void);
void (*timer_2_callback)(void);

void TIMER_1_Init(void (*callback)(void)) {
    timer_1_callback = callback;
    T1CONbits.TMR1CS = 2;   // Clock source is ext oscillator
    T1CONbits.T1CKPS = 0;   // Prescale of 1:1
    T1CONbits.T1OSCEN = 1;  // Dedicated oscillator circuit enabled
    T1CONbits.nT1SYNC = 1;  // Async external clock input
    T1CONbits.TMR1ON = 0;   // Timer stopped
    T1GCONbits.TMR1GE = 0;  // Gate disabled
    TMR1 = 0x8000;

    PIE1bits.TMR1IE = 1;    // Timer 1 overflow interrupt
}

void TIMER_1_Start(void) {
    T1CONbits.TMR1ON = 1;   // Start timer
}

void TIMER_1_Stop(void) {
    T1CONbits.TMR1ON = 0;   // Stop timer
}

void TIMER_1_Interrupt_Handler(void) {
    timer_1_callback();
    TMR1 = 0x8000;
}

void TIMER_2_Init(void (*callback)(void)) {
    timer_2_callback = callback;
    T2CONbits.T2OUTPS = 0;  // 1:1 Postscaler
    T2CONbits.TMR2ON = 0;   // Timer stopped
    T2CONbits.T2CKPS = 0;   // 1:1 Perscaler

    PIE1bits.TMR2IE = 1;    // Timer 2 overflow interrupt
}

void TIMER_2_Start(void) {
    T2CONbits.TMR2ON = 1;   // Start timer
}

void TIMER_2_Stop(void) {
    T2CONbits.TMR2ON = 0;   // Stop timer
}

void TIMER_2_Interrupt_Handler(void) {
    timer_2_callback();
}