#include <xc.h>
#include "main.h"
#include "RN-42.h"
#include "UART.h"
#include <string.h>

extern char LED_G_ON;
extern char LED_R_ON;

void RN42_Init(void) {
    if (RN42_Enter_CMD_Mode()) {
        // Set authentication to open mode
        char sa[] = "SA,0\r";
        RN42_Send_CMD(sa, 5);
        // Optimize for low latency rather than throughput
        char sq[] = "SQ,16\r";
        RN42_Send_CMD(sq, 6);
//        // Allow continuous configuration
//        char st[] = "ST,255\r";
//        RN42_Send_CMD(st, 7);
//        // Set page scan window to maximum
//        char sj[] = "SJ,800\r";
//        RN42_Send_CMD(sj, 7);
//        // Enable connection status strings
//        char so[] = "SO,!\r";
//        RN42_Send_CMD(so, 5);
        // Reboot with the new settings
        char r[] = "R,1\r";
        RN42_Send_CMD(r, 4);
    }
}

char RN42_Enter_CMD_Mode(void) {
    char ret, buffer[10];
    char cmd_mode[] = "$$$";
    UART_Write(cmd_mode, 3);
    __delay_ms(30);
    ret = UART_Read(buffer);
    if (ret == 5 && !strncmp(buffer, "CMD\r\n", 5))
        return 1;
    else
        return 0;
}

void RN42_Exit_CMD_Mode(void) {
    char ret, buffer[10];
    char cmd_ret[] = "---\r";
    UART_Write(cmd_ret, 4);
    __delay_ms(30);
    ret = UART_Read(buffer); // Exiting should return "END"
}

char RN42_Send_CMD(char *cmd, char length) {
    char ret, buffer[10];
    UART_Write(cmd, length);
    __delay_ms(30);
    ret = UART_Read(buffer);
    if (ret == 5 && !strncmp(buffer, "AOK\r\n", 5))
        return 1;
    else
        return 0;
}

char RN42_Connected_Status(void) {
    if (RN42_Enter_CMD_Mode()) {
        char ret, buffer[10], cmd[] = "GK\r";
        UART_Write(cmd, 3);
        __delay_ms(30);
        ret = UART_Read(buffer);
        if (ret == 7 && !strncmp(buffer, "1,0,0\r\n", 7)) {
            RN42_Exit_CMD_Mode();
            return 1;
        } else {
            RN42_Exit_CMD_Mode();
            return 0;
        }
    } else {
        return 0;
    }
}