#include <xc.h>
#include "main.h"
#include "MAX17040.h"
#include "I2C.h"

void MAX17040_Init(void) {
    char c[] = {MAX17040_MODE_H, 0x40, 0x00};
    I2C_Master_Send(ADDRESS_LIPO, &c, 3);
    while (!I2C_Get_Status());

}

void MAX17040_Read_Batt(char *h, char *l) {
    char result, length, buffer[10] = {0};

    char c = MAX17040_SOC_H;

    I2C_Master_Restart(ADDRESS_LIPO, c, 2);
    do {
        result = I2C_Get_Status();
    } while (!result);

    // Read received data
    length = I2C_Read_Buffer(buffer);

    // Data is received in low-high byte order
    *h = buffer[0];
    *l = buffer[1];
}