#include <xc.h>
#include "main.h"
#include "L3G.h"
#include "I2C.h"

void L3G_Init(void) {
    char c[2] = {L3G_CTRL_REG1, 0x0F};
    I2C_Master_Send(ADDRESS_GYRO, &c, 2);
    while (!I2C_Get_Status());
}

void L3G_Read_Gyro(char *x_L, char *x_H,
                   char *y_L, char *y_H,
                   char *z_L, char *z_H) {
    char result, length, buffer[10];

    // Assert the MSB to autoincrement address
    char c = L3G_OUT_X_L | (1 << 7);

    I2C_Master_Restart(ADDRESS_GYRO, c, 6);
    do {
        result = I2C_Get_Status();
    } while (!result);

    // Read received data
    length = I2C_Read_Buffer(buffer);

    // Data is received in low-high byte order
    *x_L = buffer[0];
    *x_H = buffer[1];
    *y_L = buffer[2];
    *y_H = buffer[3];
    *z_L = buffer[4];
    *z_H = buffer[5];
}