#include <xc.h>
#include "main.h"
#include "INTERRUPT.h"
#include "TIMER.h"
#include "UART.h"
#include "I2C.h"

void INTERRUPT_Init(void) {
    INTCONbits.GIE = 0;
    INTCONbits.PEIE = 1;
}

void INTERRUPT_Enable(void) {
    INTCONbits.GIE = 1;
}

void INTERRUPT_Disable(void) {
    INTCONbits.GIE = 0;
}

void interrupt INTERRUPT_Handler(void) {
    // check Timer 1 interrupt flag
    if (PIR1bits.TMR1IF) {
        TIMER_1_Interrupt_Handler();
        PIR1bits.TMR1IF = 0;
    }

    // Check Timer 2 interrupt flag
    if (PIR1bits.TMR2IF) {
        TIMER_2_Interrupt_Handler();
        PIR1bits.TMR2IF = 0;
    }

    // Check UART RX interrupt flag
    if (PIE1bits.RCIE) {
        if (PIR1bits.RCIF) {
            UART_RX_Interrupt_Handler();
//            PIR1bits.RCIF = 0; // RXIF is read-only!
        }
    }

    // Check UART TX interrupt flag
    if (PIE1bits.TXIE) {
        if (PIR1bits.TXIF) {
            UART_TX_Interrupt_Handler();
//            PIR1bits.TXIF = 0; // TXIF is read-only!
        }
    }

    // Check I2C interrupt flag
    if (PIR1bits.SSP1IF) {
        I2C_Interrupt_Handler();
        PIR1bits.SSP1IF = 0;
    }
}