// <editor-fold defaultstate="collapsed" desc="Configuration Bits">
// PIC16F1825 Configuration Bit Settings

// CONFIG1
#pragma config FOSC = INTOSC    // Oscillator Selection (INTOSC oscillator: I/O function on CLKIN pin)
#pragma config WDTE = OFF       // Watchdog Timer Enable (WDT software controlled)
#pragma config PWRTE = OFF      // Power-up Timer Enable (PWRT disabled)
#pragma config MCLRE = ON       // MCLR Pin Function Select (MCLR/VPP pin function is digital input)
#pragma config CP = OFF         // Flash Program Memory Code Protection (Program memory code protection is disabled)
#pragma config CPD = OFF        // Data Memory Code Protection (Data memory code protection is disabled)
#pragma config BOREN = ON       // Brown-out Reset Enable (Brown-out Reset enabled)
#pragma config CLKOUTEN = OFF   // Clock Out Enable (CLKOUT function is disabled. I/O or oscillator function on the CLKOUT pin)
#pragma config IESO = ON        // Internal/External Switchover (Internal/External Switchover mode is enabled)
#pragma config FCMEN = ON       // Fail-Safe Clock Monitor Enable (Fail-Safe Clock Monitor is enabled)

// CONFIG2
#pragma config WRT = OFF        // Flash Memory Self-Write Protection (Write protection off)
#pragma config PLLEN = ON       // PLL Enable (4x PLL enabled)
#pragma config STVREN = ON      // Stack Overflow/Underflow Reset Enable (Stack Overflow or Underflow will cause a Reset)
#pragma config BORV = LO        // Brown-out Reset Voltage Selection (Brown-out Reset Voltage (Vbor), low trip point selected.)
#pragma config LVP = OFF        // Low-Voltage Programming Enable (High-voltage on MCLR/VPP must be used for programming)
// </editor-fold>

#include "defines.h"
#include "INTERRUPTS.h"
#include "I2C1.h"
#include "ADC.h"

uint8_t btn_values[6];

void IO_Init(void) {
    ANSELA = 0x0;
    ANSELB = 0x0;
    ANSELC = 0x0;

    WPUA = 0x0;
    WPUB = 0x0;
    WPUC = 0x0;

    OPTION_REGbits.nWPUEN = 0;

    I2C_1_CLK_TRIS = 1;
    I2C_1_DAT_TRIS = 1;

    ANALOG_L_BTN_TRIS = 1;
    ANALOG_R_BTN_TRIS = 1;

    ANALOG_L_BTN_WPU = 1;
    ANALOG_R_BTN_WPU = 1;

    ANALOG_L_X_TRIS = 1;
    ANALOG_L_Y_TRIS = 1;

    ANALOG_R_X_TRIS = 1;
    ANALOG_R_Y_TRIS = 1;

    ANALOG_L_X_ANSEL = 1;
    ANALOG_L_Y_ANSEL = 1;

    ANALOG_R_X_ANSEL = 1;
    ANALOG_R_Y_ANSEL = 1;

    LED_A_LAT  = 0;
    LED_B_LAT  = 0;
    LED_A_TRIS = 0;
    LED_B_TRIS = 0;
}

void LED_On(void) {
    LED_A_LAT = 1;
}

void LED_Off(void) {
    LED_A_LAT = 0;
}

int main(void) {

    // Set internal oscillator speed to 32MHz
    OSCCONbits.SPLLEN = 1;  // 4x PLL enable (overwritten by config bits)
    OSCCONbits.IRCF = 0xE;  // Base frequency @ 8MHz
    OSCCONbits.SCS = 0b00;  // System clock determined by config bits

    // Initialize I/O
    IO_Init();

    // Delay a bit to allow I2C lines to stabilize
    __delay_ms(10);

    // Initialize I2C1 in slave mode
    I2C1_DATA i2c1_data;
    I2C1_Init(&i2c1_data);
    I2C1_Configure_Slave(I2C1_SLAVE_ADDR);

    // Initialize ADC
    ADC_Init();
    
    // Initialize interrupts
    Interrupt_Init();
    Interrupt_Enable();

    LED_On();
    __delay_ms(1000);
    LED_Off();

    uint8_t buffer[8];
    uint8_t length, result;

    while (1) {
        btn_values[0] = ADC_Read(ANALOG_REF_CH) >> 2;   // 0xFF
        btn_values[1] = ADC_Read(ANALOG_L_X_CH) >> 2;   // 0x7E (-1)
        btn_values[2] = ADC_Read(ANALOG_L_Y_CH) >> 2;   // 0x7C (-3)
        btn_values[3] = ADC_Read(ANALOG_R_X_CH) >> 2;   // 0x81 (+2)
        btn_values[4] = ADC_Read(ANALOG_R_Y_CH) >> 2;   // 0x7D (-2)
        btn_values[5] = (ANALOG_L_BTN_PORT << 1) | ANALOG_R_BTN_PORT;

//        // Check if an I2C message was received
//        result = I2C1_Get_Status();
//        if (result) {
//            length = I2C1_Read_Buffer(buffer);
//            if (length == 2 && buffer[0] == CMD_SET_LEDS) {
//                if (buffer[1])
//                    LED_On();
//                else
//                    LED_Off();
//            }
//        }
    }
}
