#ifndef DEFINES_H
#define	DEFINES_H

#include <xc.h>
#include <stdint.h>

// <editor-fold defaultstate="collapsed" desc="I/O Pins">

#define I2C_1_CLK_TRIS  TRISBbits.TRISB6
#define I2C_1_DAT_TRIS  TRISBbits.TRISB4

#define ANALOG_L_BTN_TRIS   TRISAbits.TRISA5
#define ANALOG_R_BTN_TRIS   TRISAbits.TRISA2

#define ANALOG_L_BTN_WPU    WPUAbits.WPUA5
#define ANALOG_R_BTN_WPU    WPUAbits.WPUA2

#define ANALOG_L_BTN_PORT   PORTAbits.RA5
#define ANALOG_R_BTN_PORT   PORTAbits.RA2

#define ANALOG_L_X_TRIS TRISCbits.TRISC3
#define ANALOG_L_Y_TRIS TRISAbits.TRISA4

#define ANALOG_L_X_ANSEL    ANSELCbits.ANSC3
#define ANALOG_L_Y_ANSEL    ANSELAbits.ANSA4

#define ANALOG_R_X_TRIS TRISCbits.TRISC7
#define ANALOG_R_Y_TRIS TRISCbits.TRISC6

#define ANALOG_R_X_ANSEL    ANSELCbits.ANSC7
#define ANALOG_R_Y_ANSEL    ANSELCbits.ANSC6

#define LED_A_TRIS  TRISCbits.TRISC5
#define LED_A_LAT   LATCbits.LATC5
#define LED_B_TRIS  TRISCbits.TRISC4
#define LED_B_LAT   LATCbits.LATC4

// </editor-fold>

#define _XTAL_FREQ      32000000

#define CMD_QUERY_BTN   0x0A
#define CMD_SET_LEDS    0x0B

#define I2C1_SLAVE_ADDR 0x10

#define ANALOG_L_X_CH   7
#define ANALOG_L_Y_CH   3

#define ANALOG_R_X_CH   9
#define ANALOG_R_Y_CH   8

#define ANALOG_REF_CH   6

#endif	/* DEFINES_H */

