#include "defines.h"
#include "INTERRUPTS.h"
#include "I2C1.h"

void Interrupt_Init() {

}

void Interrupt_Enable() {
    // Enable global and peripheral interrupts
    INTCONbits.PEIE = 1;
    INTCONbits.GIE = 1;
}

void Interrupt_Disable() {
    INTCONbits.PEIE = 0;
    INTCONbits.GIE = 0;
}

void interrupt InterruptHandler(void) {
    
    // Check to see if we have an I2C1 interrupt
    if (PIR1bits.SSP1IF) {
        // Call the handler
        I2C1_Interrupt_Handler();

        // Clear the interrupt flag
        PIR1bits.SSP1IF = 0;
    }

//    // Check to see if we have an IO interrupt
//    if (INTCONbits.IOCIF) {
//        // Call the handler
//        IO_Interrupt();
//
//        return;
//    }
    
}
