#ifndef I2C1_H
#define I2C1_H

#define MAXI2C1BUF 32

// I2C Operating Speed
#define I2C_100KHZ              0x0
#define I2C_400KHZ              0x1
#define I2C_1MHZ                0x2

// Operating State
#define I2C_IDLE                0x1
#define I2C_STARTED             0x2
#define	I2C_RCV_DATA            0x3
#define I2C_SEND_DATA           0x4
#define I2C_SEND_ADDR           0x5
#define I2C_SEND_ADDR_2         0x6
#define I2C_CHECK_ACK_SEND      0x7
#define I2C_CHECK_ACK_RECV      0x8
#define I2C_CHECK_ACK_RESTART   0x9
#define I2C_REQ_DATA            0xA
#define I2C_SEND_STOP           0xB
#define I2C_SEND_START          0xC

// Operating Mode
#define I2C_MODE_SLAVE          0x10
#define I2C_MODE_MASTER         0x11

// Master Status
#define I2C_MASTER_SEND         0x20
#define I2C_MASTER_RECV         0x21
#define I2C_MASTER_RESTART      0x22
#define I2C_MASTER_IDLE         0x23

// Return Status
#define I2C_SEND_OK             0x30
#define I2C_SEND_FAIL           0x31
#define I2C_RECV_OK             0x32
#define I2C_RECV_FAIL           0x33
#define I2C_DATA_AVAL           0x34
#define I2C_ERR_NOADDR          0x35
#define I2C_ERR_OVERRUN         0x36
#define I2C_ERR_NODATA          0x37
#define I2C_ERR_BUFFER_OVERRUN  0x38

typedef struct {
    uint8_t buffer_in[MAXI2C1BUF];
    uint8_t buffer_in_len;
    uint8_t buffer_in_len_tmp;
    uint8_t buffer_in_read_ind;
    uint8_t buffer_in_write_ind;
    
    uint8_t buffer_out[MAXI2C1BUF];
    uint8_t buffer_out_len;
    uint8_t buffer_out_ind;

    uint8_t operating_mode;
    uint8_t operating_state;
    uint8_t return_status;

    uint8_t master_dest_addr;
    uint8_t master_status;
    
    uint8_t slave_in_last_byte;
    uint8_t slave_sending_data;
} I2C1_DATA;

void I2C1_Init(I2C1_DATA *data);
void I2C1_Interrupt_Handler(void);
void I2C1_Interrupt_Slave(void);
void I2C1_Interrupt_Master(void);
void I2C1_Configure_Slave(uint8_t address);
void I2C1_Configure_Master(uint8_t speed);
void I2C1_Master_Send(uint8_t address, uint8_t length, uint8_t *msg);
void I2C1_Master_Recv(uint8_t address, uint8_t length);
void I2C1_Master_Restart(uint8_t address, uint8_t msg, uint8_t length);
uint8_t I2C1_Get_Status(void);
uint8_t I2C1_Buffer_Len(void);
uint8_t I2C1_Read_Buffer(uint8_t *buffer);
uint8_t I2C1_Process_Receive(uint8_t);

#endif