#include "defines.h"
#include "ADC.h"

void ADC_Init(void) {
    ADCON0bits.ADON = 0;        // Turn off ADC module
    ADCON1bits.ADFM = 1;        // Right justified data
    ADCON1bits.ADCS = 0b110;    // A/D conversion clock = FOSC/64
    ADCON1bits.ADNREF = 0;      // Negative reference is VSS
    ADCON1bits.ADPREF = 0b00;   // Positive reference is VDD
}

uint16_t ADC_Read(uint8_t channel) {
    uint16_t ret;

    ADCON0bits.CHS = channel;   // Set channel
    ADCON0bits.ADON = 1;        // Turn ADC on
    __delay_us(10);             // Wait the acquisition time
    ADCON0bits.GO_nDONE = 1;    // Start conversion
    while (ADCON0bits.GO_nDONE == 1);   // Wait for conversion to finish
    ret  = ADRESH << 8;         // Read ADC value
    ret |= ADRESL;

    return ret;
}
