#ifndef DEFINES_H
#define	DEFINES_H

#include <xc.h>
#include <stdint.h>
#include "STEPPER.h"

//#define CONTROL_FROM_CONTROLLER
#define CONTROL_FROM_UART

// <editor-fold defaultstate="collapsed" desc="I/O Pins">

// Stepper Driver
#define STEP_TRIS   TRISAbits.TRISA5
#define STEP_LAT    LATAbits.LATA5
#define M2_TRIS     TRISCbits.TRISC3
#define M2_LAT      LATCbits.LATC3
#define M1_TRIS     TRISCbits.TRISC4
#define M1_LAT      LATCbits.LATC4
#define M0_TRIS     TRISCbits.TRISC5
#define M0_LAT      LATCbits.LATC5

// I/O
#define SW_2_TRIS   TRISAbits.TRISA4
#define SW_2_PORT   PORTAbits.RA4
#define SW_2_INLVL  INLVLAbits.INLVLA4

#define SW_1_TRIS   TRISAbits.TRISA3
#define SW_1_PORT   PORTAbits.RA3
#define SW_1_INLVL  INLVLAbits.INLVLA3

#define STEP_CURRENT_TRIS   TRISAbits.TRISA1
#define STEP_ADC_CHANNEL    1
#define POT_CURRENT_TRIS    TRISAbits.TRISA0
#define POT_ADC_CHANNEL     0

// SPI
#define SPI_MOSI_TRIS    TRISCbits.TRISC2
#define SPI_MOSI_LAT    LATCbits.LATC2
#define SPI_CLK_TRIS     TRISCbits.TRISC0
#define SPI_CLK_LAT     LATCbits.LATC0
#define SPI_DC_SELECT_TRIS      TRISCbits.TRISC1
#define SPI_DC_SELECT_LAT       LATCbits.LATC1
#define SPI_RESET_TRIS    TRISAbits.TRISA2
#define SPI_RESET_LAT     LATAbits.LATA2

// </editor-fold>

#define _XTAL_FREQ      32000000

typedef enum {
    SINGLE_STEP,
    AUTO_STEP,
    SET_MICROSTEP
} OPERATING_MODE;

void Set_Next_Mode(void);
OPERATING_MODE Get_Cur_Mode(void);

void Update_OLED(void);
void Draw_Manual_Text(uint8_t selected);
void Draw_Auto_Text(uint8_t selected);
void Draw_Step_Text(STEPPER_MICROSTEP step, uint8_t selected);
void Draw_Stepper_Current(void);
void Draw_Pot_Value(void);

#endif	/* DEFINES_H */
