#include "defines.h"
#include "TIMER.h"

static TIMER_DATA *timer_data_p;

void TIMER_Init(TIMER_DATA *data) {
    timer_data_p = data;
}

void TIMER_2_Init(void (*callback)(void)) {
    timer_data_p->timer_2_callback = callback;
    timer_data_p->delay = 0;
    
    T2CONbits.T2OUTPS = 0b0000; // 1:1 Postscaler
    T2CONbits.T2CKPS = 0b10;    // 1:16 Prescaler
    T2CONbits.TMR2ON = 0;       // Timer stopped
    TMR2 = 6;  // Initial value of 6 (overflows every 0.5ms)

    PIE1bits.TMR2IE = 1;    // Timer 1 overflow interrupt
}

void TIMER_2_Set_Delay(uint16_t delay) {
    timer_data_p->delay = delay;
}

void TIMER_2_Start(void) {
    T2CONbits.TMR2ON = 1;   // Start timer
}

void TIMER_2_Stop(void) {
    T2CONbits.TMR2ON = 0;   // Stop timer
}

void TIMER_2_Interrupt_Handler(void) {
    TMR2 = 6;
    timer_data_p->counter++;
    if (timer_data_p->counter > timer_data_p->delay) {
        timer_data_p->timer_2_callback();
        timer_data_p->counter = 0;
    }
}
