#include "defines.h"
#include "STEPPER.h"
#include "OLED_SSD1306.h"
#include "ADC.h"
#include "TIMER.h"

static STEPPER_MICROSTEP currStep = STEP_1_1;
static uint8_t autoOn = 0;

void STEPPER_Set_Microstep(STEPPER_MICROSTEP step) {
#ifdef DVR8825
    if (step == STEP_1_1) {
        M0_LAT = 0;
        M1_LAT = 0;
        M2_LAT = 0;
    } else if (step == STEP_1_2) {
        M0_LAT = 1;
        M1_LAT = 0;
        M2_LAT = 0;
    } else if (step == STEP_1_4) {
        M0_LAT = 0;
        M1_LAT = 1;
        M2_LAT = 0;
    } else if (step == STEP_1_8) {
        M0_LAT = 1;
        M1_LAT = 1;
        M2_LAT = 0;
    } else if (step == STEP_1_16) {
        M0_LAT = 0;
        M1_LAT = 0;
        M2_LAT = 1;
    } else if (step == STEP_1_32) {
        M0_LAT = 1;
        M1_LAT = 0;
        M2_LAT = 1;
    }
#endif
}

void STEPPER_Set_Next_Step() {
    switch (currStep) {
        case STEP_1_1:
            currStep = STEP_1_2;
            break;
        case STEP_1_2:
            currStep = STEP_1_4;
            break;
        case STEP_1_4:
            currStep = STEP_1_8;
            break;
        case STEP_1_8:
            currStep = STEP_1_16;
            break;
        case STEP_1_16:
            currStep = STEP_1_32;
            break;
        case STEP_1_32:
        default:
            currStep = STEP_1_1;
            break;
    }
    STEPPER_Set_Microstep(currStep);
}

STEPPER_MICROSTEP STEPPER_Get_Cur_Step(void) {
    return currStep;
}

void STEPPER_Toggle_Auto() {
    if (autoOn == 0) {
        // Turn on automatic stepping
        TIMER_2_Init(STEPPER_Step);
        TIMER_2_Set_Delay((ADC_Read(POT_ADC_CHANNEL) >> 4) + 1);
        TIMER_2_Start();
        autoOn = 1;
    } else {
        // Turn off automatic stepping
        TIMER_2_Stop();
        autoOn = 0;
    }
}

void STEPPER_Step() {
    // Toggle step pin
    STEP_LAT = 1;
    __delay_us(2);
    STEP_LAT = 0;
    // Set the timer delay for the next step
    TIMER_2_Set_Delay((ADC_Read(POT_ADC_CHANNEL) >> 4) + 1);
}
