#ifndef SPI_H
#define	SPI_H

#define MAX_SPI_BUFFER 64
#define SPI_WRITE_ONLY

#define SPI2_FOSC_TMR2      0b0011
#define SPI2_FOSC_64        0b0010
#define SPI2_FOSC_16        0b0001
#define SPI2_FOSC_4         0b0000

typedef struct {
#ifndef SPI_WRITE_ONLY
    uint8_t buffer_in[MAX_SPI_BUFFER];
    uint8_t buffer_in_read_ind;
    uint8_t buffer_in_write_ind;
    uint8_t buffer_in_len;
#endif

    uint8_t buffer_out[MAX_SPI_BUFFER];
    uint8_t buffer_out_ind;
    uint8_t buffer_out_len;
} SPI_DATA;

void SPI_Init(SPI_DATA *data, uint8_t speed);
void SPI_Write(uint8_t *msg, uint16_t length);
void SPI2_Write_Repeat(uint8_t c, uint16_t length);
#ifndef SPI_WRITE_ONLY
void SPI_Recv_Interrupt_Handler(void);
void SPI_Read(uint8_t length);
uint8_t SPI_Buffer_Len(void);
uint8_t SPI_Read_Buffer(uint8_t *buffer);
#endif

#endif	/* SPI_H */

