#ifndef OLED_SSD1306_H
#define	OLED_SSD1306_H

/*=========================================================================
SSD1306 Displays
-----------------------------------------------------------------------
The driver is used in multiple displays (128x64, 128x32, etc.).
Select the appropriate display below to create an appropriately
sized framebuffer, etc.

SSD1306_128_64  128x64 pixel display

SSD1306_128_32  128x32 pixel display

You also need to set the LCDWIDTH and LCDHEIGHT defines to an
appropriate size

-----------------------------------------------------------------------*/
//    #define SSD1306_128_64
    #define SSD1306_128_32
/*=========================================================================*/

#if defined SSD1306_128_64
    #define SSD1306_LCDWIDTH                  128
    #define SSD1306_LCDHEIGHT                 64
#endif
#if defined SSD1306_128_32
    #define SSD1306_LCDWIDTH                  128
    #define SSD1306_LCDHEIGHT                 32
#endif

//#define SSD1306_STRING_BUFFER_SIZE          32

#define SSD1306_BLACK 0
#define SSD1306_WHITE 1

#define SSD1306_I2C_ADDRESS   0x3D	// 011110+SA0+RW

#define SSD1306_SETCONTRAST 0x81
#define SSD1306_DISPLAYALLON_RESUME 0xA4
#define SSD1306_DISPLAYALLON 0xA5
#define SSD1306_NORMALDISPLAY 0xA6
#define SSD1306_INVERTDISPLAY 0xA7
#define SSD1306_DISPLAYOFF 0xAE
#define SSD1306_DISPLAYON 0xAF
#define SSD1306_SETDISPLAYOFFSET 0xD3
#define SSD1306_SETCOMPINS 0xDA
#define SSD1306_SETVCOMDETECT 0xDB
#define SSD1306_SETDISPLAYCLOCKDIV 0xD5
#define SSD1306_SETPRECHARGE 0xD9
#define SSD1306_SETMULTIPLEX 0xA8
#define SSD1306_SETLOWCOLUMN 0x00
#define SSD1306_SETHIGHCOLUMN 0x10
#define SSD1306_SETSTARTLINE 0x40
#define SSD1306_MEMORYMODE 0x20
#define SSD1306_COMSCANINC 0xC0
#define SSD1306_COMSCANDEC 0xC8
#define SSD1306_SEGREMAP 0xA0
#define SSD1306_CHARGEPUMP 0x8D
#define SSD1306_EXTERNALVCC 0x1
#define SSD1306_SWITCHCAPVCC 0x2

typedef struct {
    int16_t WIDTH, HEIGHT; // raw display size
    int16_t _width, _height; // size depending on rotation
    int16_t cursor_x, cursor_y;
    uint16_t textcolor, textbgcolor;
    uint8_t textsize;
    uint8_t rotation;
    uint8_t wrap; // If set, wrap text at right side
} SSD1306_DATA;

// Misc functions
int16_t SSD1306_Abs(int16_t i);
void SSD1306_Swap(int16_t *a, int16_t *b);

// Core functions
void SSD1306_Init(SSD1306_DATA *data);
void SSD1306_Begin(uint8_t vcc);
void SSD1306_Command(uint8_t cmd);
void SSD1306_Data(uint8_t data);

void SSD1306_Clear_Display(void);
void SSD1306_Invert_Display(uint8_t);
void SSD1306_Display(void);

// Drawing functions
void SSD1306_Draw_Pixel(int16_t x, int16_t y, uint16_t color);
void SSD1306_Draw_Line(int16_t x0, int16_t y0, int16_t x1, int16_t y1, uint16_t color);
void SSD1306_Draw_Fast_VLine(int16_t x, int16_t y, int16_t h, uint16_t color);
void SSD1306_Draw_Fast_HLine(int16_t x, int16_t y, int16_t w, uint16_t color);
void SSD1306_Draw_Rect(int16_t x, int16_t y, int16_t w, int16_t h, uint16_t color);
void SSD1306_Fill_Rect(int16_t x, int16_t y, int16_t w, int16_t h, uint16_t color);

void SSD1306_Draw_Circle(int16_t x0, int16_t y0, int16_t r, uint16_t color);
void SSD1306_Draw_Circle_Helper(int16_t x0, int16_t y0, int16_t r, uint8_t cornername, uint16_t color);
void SSD1306_Fill_Circle(int16_t x0, int16_t y0, int16_t r, uint16_t color);
void SSD1306_Fill_Circle_Helper(int16_t x0, int16_t y0, int16_t r, uint8_t cornername, int16_t delta, uint16_t color);

void SSD1306_Draw_Triangle(int16_t x0, int16_t y0, int16_t x1, int16_t y1, int16_t x2, int16_t y2, uint16_t color);
void SSD1306_Fill_Triangle(int16_t x0, int16_t y0, int16_t x1, int16_t y1, int16_t x2, int16_t y2, uint16_t color);
void SSD1306_Draw_Round_Rect(int16_t x0, int16_t y0, int16_t w, int16_t h, int16_t radius, uint16_t color);
void SSD1306_Fill_Round_Rect(int16_t x0, int16_t y0, int16_t w, int16_t h, int16_t radius, uint16_t color);

void SSD1306_Draw_Bitmap(int16_t x, int16_t y, const uint8_t *bitmap, int16_t w, int16_t h, uint16_t color);
void SSD1306_Draw_Char(int16_t x, int16_t y, uint8_t c, uint16_t color, uint16_t bg, uint8_t size);

void SSD1306_Write(uint8_t c);
void SSD1306_Write_String(uint8_t *msg, uint8_t length);
//void SSD1306_Write_String(const rom char *fmt, ...);
//void SSD1306_Append_String(const rom char *fmt, ...);

void SSD1306_Set_Cursor(int16_t x, int16_t y);
void SSD1306_Set_Text_Color(uint16_t c);
void SSD1306_Set_Text_Color_BG(uint16_t c, uint16_t bg);
void SSD1306_Set_Text_Size(uint8_t s);
void SSD1306_Set_Text_Wrap(uint8_t w);
void SSD1306_Set_Rotation(uint8_t r);

// Test functions
void SSD1306_Test_DrawChar(void);
void SSD1306_Test_DrawCircle(void);
void SSD1306_Test_DrawRect(void);
void SSD1306_Test_FillRect(void);
void SSD1306_Test_DrawTriangle(void);
void SSD1306_Test_FillTriangle(void);
void SSD1306_Test_DrawRoundRect(void);
void SSD1306_Test_FillRoundRect(void);
void SSD1306_Test_DrawLine(void);

#endif	/* OLED_SSD1306_H */

