#include "defines.h"
#include "IOC.h"
#include "STEPPER.h"

void IOC_Init(void) {
    INTCONbits.IOCIE = 1;

    // Enable interrupt on both edges on RA3 and RA4
    IOCAPbits.IOCAP3 = 1;
    IOCANbits.IOCAN3 = 1;
    IOCAPbits.IOCAP4 = 1;
    IOCANbits.IOCAN4 = 1;
}

void IOC_Interrupt_Handler(void) {
    STEP_LAT = 1;
    STEP_LAT = 0;
    
    if (IOCAFbits.IOCAF3) {

        // Delay to debounce button on any edge
        __delay_ms(1);
        
        if (SW_1_PORT) {
            switch (Get_Cur_Mode()) {
                case SINGLE_STEP:
                    STEPPER_Step();
                    break;
                case AUTO_STEP:
                    STEPPER_Toggle_Auto();
                    break;
                case SET_MICROSTEP:
                    STEPPER_Set_Next_Step();
                    break;
            }
        }

        // Delay to debounce button on any edge
        __delay_ms(1);
        
        IOCAFbits.IOCAF3 = 0;
        return;
    }

    if (IOCAFbits.IOCAF4) {

        // Delay to debounce button on any edge
        __delay_ms(1);
        
        if (SW_2_PORT) {
            Set_Next_Mode();
        }

        // Delay to debounce button on any edge
        __delay_ms(1);

        IOCAFbits.IOCAF4 = 0;
        return;
    }
}