#include "defines.h"
#include "INTERRUPTS.h"
#include "IOC.h"
#include "SPI.h"
#include "TIMER.h"

void Interrupt_Init() {
}

void Interrupt_Enable() {
    // Enable global and peripheral interrupts
    INTCONbits.PEIE = 1;
    INTCONbits.GIE = 1;
}

void Interrupt_Disable() {
    INTCONbits.PEIE = 0;
    INTCONbits.GIE = 0;
}

void interrupt InterruptHandler(void) {
    // We need to check the interrupt flag of each enabled high-priority interrupt to
    //  see which device generated this interrupt.  Then we can call the correct handler.

    if (PIR1bits.TMR2IF) {

        TIMER_2_Interrupt_Handler();
        
        PIR1bits.TMR2IF = 0;
        return;
    }
    
    if (INTCONbits.IOCIF) {
        // Call the handler
        IOC_Interrupt_Handler();

        INTCONbits.IOCIF = 0;

        return;
    }


}
