// <editor-fold defaultstate="collapsed" desc="Configuration Bits">
// PIC16F1825 Configuration Bit Settings

// CONFIG1
#pragma config FOSC = INTOSC    // Oscillator Selection (INTOSC oscillator: I/O function on CLKIN pin)
#pragma config WDTE = OFF       // Watchdog Timer Enable (WDT enabled)
#pragma config PWRTE = OFF      // Power-up Timer Enable (PWRT disabled)
#pragma config MCLRE = ON       // MCLR Pin Function Select (MCLR/VPP pin function is digital input)
#pragma config CP = OFF         // Flash Program Memory Code Protection (Program memory code protection is disabled)
#pragma config CPD = OFF        // Data Memory Code Protection (Data memory code protection is disabled)
#pragma config BOREN = ON       // Brown-out Reset Enable (Brown-out Reset enabled)
#pragma config CLKOUTEN = OFF   // Clock Out Enable (CLKOUT function is disabled. I/O or oscillator function on the CLKOUT pin)
#pragma config IESO = ON        // Internal/External Switchover (Internal/External Switchover mode is enabled)
#pragma config FCMEN = ON       // Fail-Safe Clock Monitor Enable (Fail-Safe Clock Monitor is enabled)

// CONFIG2
#pragma config WRT = OFF        // Flash Memory Self-Write Protection (Write protection off)
#pragma config PLLEN = OFF      // PLL Disabled (4x PLL disabled)
#pragma config STVREN = ON      // Stack Overflow/Underflow Reset Enable (Stack Overflow or Underflow will cause a Reset)
#pragma config BORV = LO        // Brown-out Reset Voltage Selection (Brown-out Reset Voltage (Vbor), low trip point selected.)
#pragma config LVP = OFF        // Low-Voltage Programming Enable (High-voltage on MCLR/VPP must be used for programming)
// </editor-fold>

#include "defines.h"
#include "INTERRUPTS.h"
#include "I2C1.h"
#include "HT16K33.h"
#include "SMT6500.h"
#include "IOC.h"
//#include "UART.h"

void Pins_Init(void) {
    // Set all pins to digital I/O
    ANSELA = 0x0;
    ANSELC = 0x0;

//    // Enable weak pull-up if WPU bit is set
//    OPTION_REGbits.nWPUEN = 0;

    BLNK_LAT = 0;
    BLNK_TRIS = 0;
    
    INIT_LAT = 0;
    INIT_TRIS = 0;
    
    BINH_LAT = 0;
    BINH_TRIS = 0;
    
    OSC_TRIS = 1;
    ECHO_TRIS = 1;
}

int main(void) {
    // Set internal oscillator speed to 16MHz
    OSCCONbits.SPLLEN = 0;  // 4x PLL disabled (overwritten by config bits)
    OSCCONbits.IRCF = 0b1111;  // Base frequency @ 4MHz
    OSCCONbits.SCS = 0b00;  // System clock determined by config bits

    // Initialize I/O
    Pins_Init();
    SMT6500_Init();

    // Initialize I2C
    I2C1_DATA i2c_data;
    I2C1_Init(&i2c_data);
    I2C1_Configure_Master(I2C_400KHZ);

//    UART_DATA uart_data;
//    UART_Init(&uart_data);

    IOC_DATA ioc_data;
    IOC_Init(&ioc_data, SMT6500_Callback);

    LED_DATA led_data;
    LED_Init(&led_data);

    // Initialize interrupts
    Interrupt_Init();
    Interrupt_Enable();

    __delay_ms(100);

    LED_Start();

    while (1) {
        uint16_t distance = SMT6500_Read() / 7;
        LED_Write_Num(distance);
//        __delay_ms(100);
        
    }
}
