#ifndef DEFINES_H
#define	DEFINES_H

#include <xc.h>
#include <stdint.h>

// <editor-fold defaultstate="collapsed" desc="I/O Pins">

// Resets the ECHO output for the next return signal
// Must be high at least 0.44ms
#define BLNK_TRIS   TRISCbits.TRISC4
#define BLNK_LAT    LATCbits.LATC4

// Starts the 16 pulse transmit
#define INIT_TRIS   TRISCbits.TRISC3
#define INIT_LAT    LATCbits.LATC3

// Ends the internal blanking early
#define BINH_TRIS   TRISCbits.TRISC2
#define BINH_LAT    LATCbits.LATC2

// 420kHz time base
#define OSC_TRIS    TRISAbits.TRISA5

// Return signal
#define ECHO_TRIS   TRISAbits.TRISA4

#define I2C_1_CLK_TRIS  TRISCbits.TRISC0
#define I2C_1_DAT_TRIS  TRISCbits.TRISC1

#define UART_RX_TRIS    TRISAbits.TRISA1
#define UART_TX_TRIS    TRISAbits.TRISA0

// </editor-fold>

#define _XTAL_FREQ      16000000

#endif	/* DEFINES_H */
