#include "defines.h"
#include "TIMER.h"

void TIMER1_Init(void) {
    T1CONbits.TMR1CS = 0x0;   // Clock source is instruction clock
    T1CONbits.T1CKPS = 0x3;   // Prescale of 1:8
    T1CONbits.T1OSCEN = 0x0;  // Dedicated oscillator circuit disabled
    T1CONbits.nT1SYNC = 0x0;  // Sync clock input with system clock
    T1CONbits.TMR1ON = 0;   // Timer starts off
    T1GCONbits.TMR1GE = 0;  // Gate disabled
    TMR1 = 0x0;

    PIE1bits.TMR1IE = 0;    // Interrupt disabled

    // Instruction clock running at 8MHz
    // 1:1 Prescale overflows at 122Hz (8.2ms period)
    // 1:2 Prescale overflows at 61Hz (16.4ms period)
    // 1:4 Prescale overflows at 30.5Hz (32.7ms period)
    // 1:8 Prescale overflows at 15.3Hz (65.5ms period)

    // Instruction clock running at 4MHz
    // 1:1 Prescale overflows at 61Hz (16.4ms period)
    // 1:2 Prescale overflows at 30.5Hz (32.7ms period)
    // 1:4 Prescale overflows at 15.3Hz (65.5ms period)
    // 1:8 Prescale overflows at 7.6Hz (131.1ms period)
}

void TIMER1_Start(void) {
    TMR1 = 0x0;
    T1CONbits.TMR1ON = 1;
}

void TIMER1_Stop(void) {
    T1CONbits.TMR1ON = 0;
}

uint16_t TIMER1_Read(void) {
    return TMR1;
}

void TIMER1_Interrupt_Handler(void) {

}
