#include "defines.h"
#include "SMT6500.h"
#include "TIMER.h"
#include "IOC.h"

static uint16_t tmr_value;

void SMT6500_Init(void) {
    BLNK_LAT = 0;
    INIT_LAT = 0;
    BINH_LAT = 0;
}

uint16_t SMT6500_Read(void) {
    // Start transmission and timer
    INIT_LAT = 1;
    TIMER1_Start();
    tmr_value = 0;
    
    // Enable interrupt after 1ms (blanking period)
    __delay_ms(1);
    IOC_Enable();
    
    __delay_ms(120);
    INIT_LAT = 0;
    IOC_Disable();
    TIMER1_Stop();


    if (tmr_value == 0) {
        return 0xFFFF;
    } else {
        return tmr_value;
    }
}

void SMT6500_Callback(void) {
    tmr_value = TIMER1_Read();
    IOC_Disable();
    TIMER1_Stop();
}
