#include "defines.h"
#include "IOC.h"

static IOC_DATA *data_p;

void IOC_Init(IOC_DATA *data, void (*callback)(void)) {
    data_p = data;
    data_p->ioc_callback = callback;

    INTCONbits.IOCIE = 0;

    // Enable interrupt on rising edge on RA4
    IOCAPbits.IOCAP4 = 1;
}

void IOC_Enable(void) {
    IOC_Clear();
    INTCONbits.IOCIE = 1;
}

void IOC_Disable(void) {
    INTCONbits.IOCIE = 0;
    IOC_Clear();
}

void IOC_Clear(void) {
    IOCAF = 0x0;
}

void IOC_Interrupt_Handler(void) {
    data_p->ioc_callback();
}