#include "defines.h"
#include "INTERRUPTS.h"
#include "I2C1.h"
#include "UART.h"
#include "IOC.h"

void Interrupt_Init() {
}

void Interrupt_Enable() {
    // Enable global and peripheral interrupts
    INTCONbits.PEIE = 1;
    INTCONbits.GIE = 1;
}

void Interrupt_Disable() {
    INTCONbits.PEIE = 0;
    INTCONbits.GIE = 0;
}

void interrupt InterruptHandler(void) {
    // We need to check the interrupt flag of each enabled high-priority interrupt to
    //  see which device generated this interrupt.  Then we can call the correct handler.

    // Check to see if we have an I2C interrupt
    if (PIR1bits.SSP1IF) {

        // Call the handler
        I2C1_Interrupt_Handler();

        // Clear the interrupt flag
        PIR1bits.SSP1IF = 0;

//        return;
    }
    
    // Check for an IOC interrupt
    if (INTCONbits.IOCIF) {

        // Call the handler
        IOC_Interrupt_Handler();

        // Clear the interrupt flag
        INTCONbits.IOCIF = 0;

//        return;
    }
    
//    if (PIR1bits.RCIF) {
//
//        // Call the handler
//        UART_RX_Interrupt_Handler();
//
//        // Clear the interrupt flag
//        PIR1bits.RCIF = 0;
//
//        return;
//    }

//    if (PIR1bits.TXIF) {
//
//        // Call the handler
//        UART_TX_Interrupt_Handler();
//
//        // Clear the interrupt flag
//        PIR1bits.TXIF = 0;
//
//        return;
//    }

}
