#ifndef LED_BACKPACK_H
#define	LED_BACKPACK_H

#include "defines.h"

#define HT16K33_ADDRESS 0x70

#define HT16K33_BLINK_CMD 0x80
#define HT16K33_BLINK_DISPLAYON 0x01
#define HT16K33_BLINK_OFF 0
#define HT16K33_BLINK_2HZ  1
#define HT16K33_BLINK_1HZ  2
#define HT16K33_BLINK_HALFHZ  3

#define HT16K33_CMD_BRIGHTNESS 0x0E

typedef struct {
    uint8_t i2c_address;
    uint8_t display_buffer[17];
} LED_DATA;

void LED_Init(LED_DATA *data);
void LED_Start(void);
void LED_Set_Brightness(uint8_t c);
void LED_Blink_Rate(uint8_t c);
void LED_Write_Display(void);
void LED_Clear(void);
void LED_Draw_Colon(uint8_t c);
void LED_Write_Digit_Raw(uint8_t loc, uint8_t bitmask);
void LED_Write_Digit_Num(uint8_t loc, uint8_t num, uint8_t dot);
void LED_Write_Digit_Alpha(uint8_t loc, uint8_t alpha, uint8_t dot);
void LED_Write_Num(uint16_t i);


#endif	/* LED_BACKPACK_H */

