#include "DEFINES.h"
#include "IOC.h"
#include "PWM.h"

void IOC_Init() {
    // Enable global IOC interrupt
    INTCONbits.IOCIE = 1;

    IOC_TRIS = 1;

    // Enable IOC on rising edge only
    IOC_IOCAP = 0;
    IOC_IOCAN = 1;
}

void IOC_Interrupt_Handler() {
    // Transmit the saved pattern
    if (IOC_IOCAF)
        PWM_Transmit_Pattern();

    // Clear all status flags
    IOC_IOCAF = 0;
}
