#include "DEFINES.h"
#include "INTERRUPTS.h"
#include "IOC.h"
#include "EUSART.h"

void Interrupt_Enable() {
    INTCONbits.GIE = 1;
    INTCONbits.PEIE = 1;
}

void Interrupt_Disable() {
    INTCONbits.GIE = 0;
    INTCONbits.PEIE = 0;
}

void interrupt InterruptHandler(void) {

    // Check for an IOC interrupt
    if (INTCONbits.IOCIF) {
        IOC_Interrupt_Handler();
        INTCONbits.IOCIF = 0;
        return;
    }

    // Check to see if we have an interrupt on USART1 RX
    if (PIR1bits.RCIF) {
        UART_RX_Interrupt_Handler();
        PIR1bits.RCIF = 0;
        return;
    }

    // Check to see if we have an interrupt on USART1 TX
    if (PIR1bits.TXIF) {
        UART_TX_Interrupt_Handler();
//        PIR1bits.TXIF = 0;
        return;
    }

}
