#include <xc.h>
#include "defines.h"
#include "INTERRUPTS.h"
#include "NEOPIXEL.h"

// <editor-fold defaultstate="collapsed" desc="Configuration Registers">
/* Config Register CONFIGL @ 0x8007 */
#pragma config CPD = OFF    // Data memory code protection is disabled
#pragma config BOREN = OFF  // Brown-out Reset disabled
#pragma config IESO = OFF   // Internal/External Switchover mode is disabled
#pragma config FOSC = INTOSC    // INTOSC oscillator: I/O function on CLKIN pin
#pragma config FCMEN = OFF  // Fail-Safe Clock Monitor is disabled
#pragma config MCLRE = ON   // MCLR/VPP pin function is MCLR
#pragma config WDTE = OFF   // WDT disabled
#pragma config CP = OFF     // Program memory code protection is disabled
#pragma config PWRTE = OFF  // PWRT disabled
#pragma config CLKOUTEN = OFF   // CLKOUT function is disabled. I/O or oscillator function on the CLKOUT pin

/* Config Register CONFIG2 @ 0x8008 */
#pragma config PLLEN = ON   // 4x PLL disabled
#pragma config WRT = OFF    // Write protection off
#pragma config STVREN = OFF // Stack Overflow or Underflow will not cause a Reset
#pragma config BORV = HI    // Brown-out Reset Voltage (Vbor), high trip point selected.
#pragma config LVP = OFF    // High-voltage on MCLR/VPP must be used for programming
// </editor-fold>

NEOPIXEL_DATA neopixel_data;

int main() {

    // Oscillator configuration (32Mhz HFINTOSC)
    OSCCONbits.SCS = 0b00;
    OSCCONbits.IRCF = 0b1110;
    
    ANSELA = 0x00;  // All pins set to digital I/O
    APFCONbits.CCP1SEL = 1; // Switch CCP1 from RA2 to RA5

    // Wait for HFINTOSC to be within 0.5% of target 32Mhz
    while (!OSCSTATbits.HFIOFS);

//    Interrupt_Enable();
    
    NeoPixel_Init(&neopixel_data);

    for (char i = 0; i < 60; i++) {
        if (i % 6 == 0)
            NeoPixel_Set(i, RED);
        else if (i % 6 == 1)
            NeoPixel_Set(i, ORANGE);
        else if (i % 6 == 2)
            NeoPixel_Set(i, YELLOW);
        else if (i % 6 == 3)
            NeoPixel_Set(i, GREEN);
        else if (i % 6 == 4)
            NeoPixel_Set(i, BLUE);
        else
            NeoPixel_Set(i, PURPLE);
    }
    
    while(1) {
        NeoPixel_Write_All();
    }
}
