#ifndef NEOPIXEL_H
#define	NEOPIXEL_H

#define NEOPIXEL_LENGTH 60

#define NEOPIXEL_LOGIC_1 0b00000110
#define NEOPIXEL_LOGIC_0 0b00000011

// Color Definitions
#define CLEAR   0x00,0x00,0x00
#define RED     0xFF,0x00,0x00
#define ORANGE  0x8F,0x20,0x00
#define YELLOW  0x8F,0x8F,0x00
#define GREEN   0x00,0xFF,0x00
#define TEAL    0x00,0x8F,0x40
#define BLUE    0x00,0x00,0xFF
#define PURPLE  0x8F,0x00,0x8F
#define WHITE   0x6F,0x6F,0x6F

typedef struct {
    char values[NEOPIXEL_LENGTH * 3];
} NEOPIXEL_DATA;

void NeoPixel_Init(NEOPIXEL_DATA *data);
void NeoPixel_Set(char index, char R, char G, char B);
void NeoPixel_Write_All(void);
void NeoPixel_Write_One(char value);

#endif	/* NEOPIXEL_H */

