#include <xc.h>
#include "defines.h"
#include "base_INTERRUPTS.h"
//#include "base_UART.h"
#include "base_CPS.h"
#include "base_PWM.h"

// <editor-fold defaultstate="collapsed" desc="Configuration Registers">
/* Config Register CONFIGL @ 0x8007 */
#pragma config CPD = OFF    // Data memory code protection is disabled
#pragma config BOREN = OFF   // Brown-out Reset disabled
#pragma config IESO = OFF   // Internal/External Switchover mode is disabled
#pragma config FOSC = INTOSC    // INTOSC oscillator: I/O function on CLKIN pin
#pragma config FCMEN = OFF  // Fail-Safe Clock Monitor is disabled
#pragma config MCLRE = ON   // MCLR/VPP pin function is MCLR
#pragma config WDTE = OFF   // WDT disabled
#pragma config CP = OFF     // Program memory code protection is disabled
#pragma config PWRTE = OFF  // PWRT disabled
#pragma config CLKOUTEN = OFF   // CLKOUT function is disabled. I/O or oscillator function on the CLKOUT pin

/* Config Register CONFIG2 @ 0x8008 */
#pragma config PLLEN = OFF  // 4x PLL disabled
#pragma config WRT = OFF    // Write protection off
#pragma config STVREN = OFF // Stack Overflow or Underflow will not cause a Reset
#pragma config BORV = HI    // Brown-out Reset Voltage (Vbor), high trip point selected.
#pragma config LVP = OFF    // High-voltage on MCLR/VPP must be used for programming
// </editor-fold>

int main() {

    // Oscillator configuration (16Mhz HFINTOSC)
    OSCCONbits.SCS = 0b00;
    OSCCONbits.IRCF = 0b1111;
    
    ANSELA = 0x00;  // All pins set to digital I/O
    APFCONbits.CCP1SEL = 1; // Switch CCP1 from RA2 to RA5
    APFCONbits.TXCKSEL = 1; // Switch TX/CK from RA0 to RA4
    APFCONbits.RXDTSEL = 1; // Switch RX/DT from RA1 to RA5

    /* Set pins as analog */
    /* 0x01 = ANSA0 (RA0)
     * 0x02 = ANSA1 (RA1)
     * 0x04 = ANSA2 (RA2)
     * 0x10 = ANSA4 (RA4) */
    ANSELA = 0x03;
    
    Interrupt_Enable();

//    UART_DATA uart_data;
//    UART_Init(&uart_data);

    CPS_DATA cps_data;
    CPS_Init(&cps_data);

    PWM_Init();
    
//    char msg[] = "Begin Program\n";
//    UART_Write(msg, 14);

    LED_TRIS = 0;

    while(1) {
//        __delay_ms(10);

//        unsigned int value = cps_data.btn_last_value[cps_data.channel];
//        unsigned int avg = cps_data.btn_avg_value[cps_data.channel];
//        unsigned char output[9];
//        output[0] = cps_data.channel;
//        output[1] = 0;
//        output[2] = value >> 8;
//        output[3] = value;
//        output[4] = 0;
//        output[5] = avg >> 8;
//        output[6] = avg;
//        output[7] = 0;
//        output[8] = cps_data.btn_pct_value[cps_data.channel];
//        UART_WriteD(output, 9);

        if (cps_data.btn_pressed[0] || cps_data.btn_pressed[1]) {
            LED_LAT = 1;
            PWM_Set_Width(1350);
        } else {
            LED_LAT = 0;
            PWM_Set_Width(800);
        }
    }
}
